/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jbpm.gd.common.editor.ContextMenuProvider;
import org.jbpm.gd.common.editor.Editor;

public abstract class OutlineViewer
extends ContentOutlinePage {
    private Control treeview;
    private Editor editor;

    public OutlineViewer(Editor editor) {
        super((EditPartViewer)new TreeViewer());
        editor.getSelectionSynchronizer().addViewer(this.getViewer());
        this.editor = editor;
    }

    protected abstract void initEditPartFactory();

    public void createControl(Composite parent) {
        this.createTreeview(parent);
    }

    private void createTreeview(Composite parent) {
        this.treeview = this.getViewer().createControl(parent);
        ContextMenuProvider provider = new ContextMenuProvider(this.getViewer(), this.editor.getActionRegistry());
        this.getViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.jbpm.gd.common.outline.context", (MenuManager)provider, (ISelectionProvider)this.getViewer());
        this.treeview.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                OutlineViewer.this.handleDoubleClick();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.getViewer().setEditDomain(this.editor.getGraphicalViewer().getEditDomain());
        this.initEditPartFactory();
        this.setContents(this.editor.getRootContainer().getSemanticElement());
    }

    private void handleDoubleClick() {
        EditPart editPart = (EditPart)this.getViewer().getSelectedEditParts().get(0);
        Request openPropertiesRequest = new Request((Object)"open");
        editPart.performRequest(openPropertiesRequest);
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Control getControl() {
        return this.treeview;
    }

    public void setFocus() {
        if (this.getControl() != null) {
            this.getControl().setFocus();
        }
    }

    public void setContents(Object contents) {
        this.getViewer().setContents(contents);
    }

    protected void setEditPartFactory(EditPartFactory factory) {
        this.getViewer().setEditPartFactory(factory);
    }
}

