/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.jpdl.Plugin;

public class PaletteRoot
extends org.eclipse.gef.palette.PaletteRoot {
    private Editor editor;
    private List categoryList = new ArrayList();
    private Map categoryMap = new HashMap();

    public PaletteRoot(Editor editor) {
        this.editor = editor;
        this.addControls();
    }

    private void addControls() {
        this.add((PaletteEntry)this.createDefaultControls());
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.jbpm.gd.jpdl.palette");
        int i = 0;
        while (i < configurationElements.length) {
            String editorClass = configurationElements[i].getAttribute("editorClass");
            if (editorClass != null && editorClass.equals(((Object)((Object)this.editor)).getClass().getName())) {
                this.processPaletteContribution(configurationElements[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.categoryList.size()) {
            IConfigurationElement categoryElement = (IConfigurationElement)this.categoryList.get(i);
            String categoryName = String.valueOf(categoryElement.getNamespaceIdentifier()) + "." + categoryElement.getAttribute("id");
            List entries = (List)this.categoryMap.get(categoryName);
            if (entries != null && !entries.isEmpty()) {
                PaletteGroup paletteGroup = new PaletteGroup(categoryName);
                int j = 0;
                while (j < entries.size()) {
                    IConfigurationElement entryElement = (IConfigurationElement)entries.get(j);
                    String icon = entryElement.getAttribute("icon");
                    String entryName = String.valueOf(entryElement.getNamespaceIdentifier()) + "." + entryElement.getAttribute("id");
                    String label = entryElement.getAttribute("label");
                    boolean isNode = !"false".equals(entryElement.getAttribute("node"));
                    String object = entryElement.getAttribute("object");
                    String tooltip = entryElement.getAttribute("tooltip");
                    CreationFactory factory = new CreationFactory(object, this.editor.getSemanticElementFactory(), this.editor.getNotationElementFactory());
                    Object entry = isNode ? new CreationToolEntry(label, tooltip, (org.eclipse.gef.requests.CreationFactory)factory, this.getIconDescriptor(icon), null) : new ConnectionCreationToolEntry(label, tooltip, (org.eclipse.gef.requests.CreationFactory)factory, this.getIconDescriptor(icon), null);
                    entry.setId(entryName);
                    paletteGroup.add((PaletteEntry)entry);
                    ++j;
                }
                this.add((PaletteEntry)paletteGroup);
            }
            ++i;
        }
    }

    private ImageDescriptor getIconDescriptor(String icon) {
        return ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/" + icon));
    }

    private void processPaletteContribution(IConfigurationElement configurationElement) {
        IConfigurationElement[] elements = configurationElement.getChildren("category");
        int i = 0;
        while (i < elements.length) {
            this.categoryList.add(elements[i]);
            ++i;
        }
        elements = configurationElement.getChildren("entry");
        i = 0;
        while (i < elements.length) {
            ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)this.categoryMap.get(elements[i].getAttribute("category"));
            if (list == null) {
                list = new ArrayList<IConfigurationElement>();
                this.categoryMap.put(elements[i].getAttribute("category"), list);
            }
            list.add(elements[i]);
            ++i;
        }
    }

    private PaletteGroup createDefaultControls() {
        PaletteGroup controls = new PaletteGroup("Default Tools");
        controls.setId("org.jbpm.palette.DefaultTools");
        this.addSelectionTool(controls);
        this.addMarqueeTool(controls);
        return controls;
    }

    private void addMarqueeTool(PaletteGroup controls) {
        MarqueeToolEntry tool = new MarqueeToolEntry();
        tool.setId("org.jbpm.ui.palette.Marquee");
        controls.add((PaletteEntry)tool);
    }

    private void addSelectionTool(PaletteGroup controls) {
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setId("org.jbpm.ui.palette.Selection");
        controls.add((PaletteEntry)tool);
        this.setDefaultEntry((ToolEntry)tool);
    }
}

