/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.notation;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;

public class RootContainer
extends AbstractNotationElement
implements NodeContainer {
    Dimension dimension;
    List nodes = new ArrayList();

    public void setDimension(Dimension newDimension) {
        Dimension oldDimension = this.dimension;
        this.dimension = newDimension;
        this.firePropertyChange("dimension", oldDimension, newDimension);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        node.setContainer(this);
        this.firePropertyChange("nodeAdd", null, node);
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
        node.setContainer(null);
        this.firePropertyChange("nodeRemove", node, null);
    }

    public List getNodes() {
        return this.nodes;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    protected void removeNode(PropertyChangeEvent evt) {
        SemanticElement jpdlElement = (SemanticElement)evt.getOldValue();
        AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(jpdlElement);
        if (notationElement != null) {
            jpdlElement.removePropertyChangeListener(notationElement);
            this.removeNode((Node)notationElement);
        }
    }

    protected void addNode(PropertyChangeEvent evt) {
        SemanticElement semanticElement = (SemanticElement)evt.getNewValue();
        AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(semanticElement);
        if (notationElement == null) {
            CreationFactory factory = new CreationFactory(semanticElement.getElementId(), semanticElement.getFactory(), this.getFactory());
            notationElement = (AbstractNotationElement)factory.getNewObject();
        }
        this.addNode((Node)notationElement);
        semanticElement.addPropertyChangeListener(notationElement);
    }
}

