/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.registry;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jbpm.gd.common.registry.SemanticElementRegistry;
import org.jbpm.gd.common.registry.XmlAdapterRegistry;
import org.jbpm.gd.jpdl.Logger;

public class RegistryRegistry {
    private static HashMap editorRegistry = new HashMap();
    private static HashMap semanticElementRegistries = new HashMap();
    private static HashMap xmlAdapterRegistries = new HashMap();

    static {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.jbpm.gd.jpdl.dsl");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String editorId = configElements[j].getAttribute("editor");
                String language = configElements[j].getAttribute("id");
                editorRegistry.put(editorId, language);
                ++j;
            }
            ++i;
        }
    }

    public static SemanticElementRegistry getSemanticElementRegistry(String editorId) throws RuntimeException {
        String language;
        SemanticElementRegistry result = (SemanticElementRegistry)semanticElementRegistries.get(editorId);
        if (result == null && (language = (String)editorRegistry.get(editorId)) != null) {
            result = new SemanticElementRegistry(language);
        }
        if (result == null) {
            RegistryRegistry.handleError(editorId);
        }
        return result;
    }

    private static void handleError(String editorId) {
        String message = "Editor " + editorId + " has no associated language";
        RuntimeException e = new RuntimeException(message);
        Logger.logError(message, e);
        throw e;
    }

    public static XmlAdapterRegistry getXmlAdapterRegistry(String editorId) throws RuntimeException {
        SemanticElementRegistry semanticElementRegistry;
        String language;
        XmlAdapterRegistry result = (XmlAdapterRegistry)xmlAdapterRegistries.get(editorId);
        if (result == null && (language = (String)editorRegistry.get(editorId)) != null && (semanticElementRegistry = RegistryRegistry.getSemanticElementRegistry(editorId)) != null) {
            result = new XmlAdapterRegistry(semanticElementRegistry.getSemanticElementIds());
        }
        if (result == null) {
            RegistryRegistry.handleError(editorId);
        }
        return result;
    }
}

