/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.xml;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.registry.XmlAdapterRegistry;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XmlAdapter
implements PropertyChangeListener,
INodeAdapter {
    private static final String PADDING = "\t";
    private static final String INTER_NODE_TYPE_SPACING = "\n";
    private static final String INTER_CHILD_SPACING = "\n";
    private static final String[] CHILD_ELEMENTS = new String[0];
    private static HashMap NODE_TYPES = null;
    private Node node;
    private SemanticElement semanticElement;
    private XmlAdapterFactory factory;

    protected void initialize(String elementType, Document document) {
        this.node = document.createElement(elementType);
    }

    protected void initialize() {
    }

    public String getElementType() {
        return this.node != null ? this.node.getNodeName() : null;
    }

    protected String[] getChildElements() {
        return CHILD_ELEMENTS;
    }

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
        }
        return NODE_TYPES;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    protected void addElements(SemanticElement[] jpdlElements) {
        int i = 0;
        while (i < jpdlElements.length) {
            this.addElement(jpdlElements[i]);
            ++i;
        }
    }

    protected void addElement(XmlAdapter adapter) {
        if (adapter == null) {
            return;
        }
        if (this.contains(adapter)) {
            return;
        }
        Node insertionPoint = null;
        int level = this.getLevel();
        if (this.isEmpty()) {
            insertionPoint = this.node.appendChild(this.node.getOwnerDocument().createTextNode(String.valueOf(this.getInterNodeTypeSpacing()) + this.getPaddingString(level - 1)));
            insertionPoint = this.node.insertBefore(adapter.getNode(), insertionPoint);
            this.node.insertBefore(this.node.getOwnerDocument().createTextNode(String.valueOf(this.getInterNodeTypeSpacing()) + this.getPaddingString(level)), insertionPoint);
        } else if (this.hasNode(this.getNodeType(adapter.getElementType()))) {
            insertionPoint = this.getLastNode(this.getNodeType(adapter.getElementType())).getNextSibling();
            if (insertionPoint == null) {
                insertionPoint = this.node.appendChild(this.node.getOwnerDocument().createTextNode(this.getInterNodeTypeSpacing()));
            }
            insertionPoint = this.node.insertBefore(adapter.getNode(), insertionPoint);
            this.node.insertBefore(this.node.getOwnerDocument().createTextNode(String.valueOf(this.getInterChildSpacing()) + this.getPaddingString(level)), insertionPoint);
        } else {
            insertionPoint = this.prepareInsertionPoint(this.getNodeType(adapter.getElementType()), level);
            this.node.insertBefore(adapter.getNode(), insertionPoint);
        }
        adapter.initialize();
        this.node.normalize();
    }

    private boolean contains(XmlAdapter adapter) {
        Node parent = this.getNode();
        Node child = adapter.getNode();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) == child) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getInterNodeTypeSpacing() {
        return "\n";
    }

    protected String getInterChildSpacing() {
        return "\n";
    }

    private Node prepareInsertionPoint(String nodeType, int level) {
        boolean before = false;
        Node insertAfter = null;
        Node insertBefore = null;
        int i = 0;
        while (i < this.getChildElements().length) {
            if (this.getChildElements()[i].equals(nodeType)) {
                before = true;
            } else if (before) {
                if (insertBefore == null) {
                    insertBefore = this.getFirstNode(this.getChildElements()[i]);
                }
            } else {
                Node candidateAfter = this.getLastNode(this.getChildElements()[i]);
                if (candidateAfter != null) {
                    insertAfter = candidateAfter;
                }
            }
            ++i;
        }
        if (before && insertBefore != null) {
            return this.node.insertBefore(this.node.getOwnerDocument().createTextNode(String.valueOf(this.getInterNodeTypeSpacing()) + this.getPaddingString(level)), insertBefore);
        }
        if (insertAfter != null) {
            Node candidate = insertAfter.getNextSibling();
            if (candidate != null) {
                this.node.insertBefore(this.node.getOwnerDocument().createTextNode(String.valueOf(this.getInterNodeTypeSpacing()) + this.getPaddingString(level)), candidate);
                return candidate;
            }
            return this.node.appendChild(this.node.getOwnerDocument().createTextNode(this.getInterNodeTypeSpacing()));
        }
        return this.node.appendChild(this.node.getOwnerDocument().createTextNode(this.getInterNodeTypeSpacing()));
    }

    protected void removeElement(XmlAdapter adapter) {
        if (adapter == null) {
            return;
        }
        Node last = this.getLastNode(this.getNodeType(adapter.getElementType()));
        Node toDelete = adapter.getNode();
        Node parent = toDelete.getParentNode();
        if (parent != null && parent == this.node) {
            if (toDelete == last) {
                this.removeTextChild(toDelete.getPreviousSibling());
            } else {
                this.removeTextChild(toDelete.getNextSibling());
            }
            this.node.removeChild(toDelete);
            if (this.hasOnlyTextChildren()) {
                this.emptyNode();
            }
            this.node.normalize();
        }
    }

    protected void removeFirst(String nodeType) {
        Node toDelete = this.getFirstNode(nodeType);
        if (toDelete != null) {
            this.removeTextChild(toDelete.getPreviousSibling());
            this.removeTextChild(toDelete.getNextSibling());
            this.getNode().removeChild(toDelete);
        }
    }

    private int getLevel() {
        int result = 0;
        Node node = this.getNode();
        Document document = this.getNode().getOwnerDocument();
        while (node != null && node != document) {
            ++result;
            node = node.getParentNode();
        }
        return result;
    }

    private String getPaddingString(int level) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append(PADDING);
            ++i;
        }
        return result.toString();
    }

    protected String getNodeType(String elementType) {
        return (String)this.getNodeTypes().get(elementType);
    }

    protected boolean isEmpty() {
        NodeList childNodes = this.node.getChildNodes();
        int length = childNodes.getLength();
        if (length == 0) {
            return true;
        }
        int i = 0;
        while (i < length) {
            if (childNodes.item(i).getNodeType() != 3 || !"".equals(childNodes.item(i).getNodeValue().trim())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean hasOnlyTextChildren() {
        NodeList list = this.node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() != 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isNodeOfType(Node node, String type) {
        boolean result = false;
        XmlAdapter adapter = this.getFactory().adapt(node);
        if (adapter != null) {
            result = adapter.getElementType().equals(type);
        }
        return type.equals(this.getNodeTypes().get(node.getNodeName())) || result;
    }

    protected void emptyNode() {
        Node first = this.node.getFirstChild();
        while (first != null) {
            this.node.removeChild(first);
            first = this.node.getFirstChild();
        }
    }

    protected Node getFirstNode(String nodeType) {
        NodeList list = this.node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node item = list.item(i);
            if (item.getNodeType() == 1 && this.isNodeOfType(item, nodeType)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected Node getLastNode(String nodeType) {
        NodeList list = this.node.getChildNodes();
        int i = list.getLength();
        while (i > 0) {
            Node item = list.item(i - 1);
            if (item.getNodeType() == 1 && this.isNodeOfType(item, nodeType)) {
                return item;
            }
            --i;
        }
        return null;
    }

    protected boolean hasNode(String nodeType) {
        return this.getFirstNode(nodeType) != null;
    }

    protected void removeTextChild(Node child) {
        if (child != null && child.getNodeType() == 3 && "".equals(child.getNodeValue().trim())) {
            this.node.removeChild(child);
        }
    }

    protected void setTextContent(String content) {
        String oldContents = this.getTextContent();
        if (oldContents == null && content == null) {
            return;
        }
        if (oldContents.equals(content)) {
            return;
        }
        this.removeTextChildren();
        if (content != null) {
            this.replaceTextChild(content);
        }
    }

    private void removeTextChildren() {
        NodeList list = this.getNode().getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 3) {
                this.getNode().removeChild(list.item(i));
            }
            ++i;
        }
    }

    private void replaceTextChild(String content) {
        int level = this.getLevel();
        StringBuffer buff = new StringBuffer();
        buff.append(this.getInterNodeTypeSpacing());
        buff.append(this.getPaddingString(level));
        buff.append(content);
        buff.append(this.getInterNodeTypeSpacing());
        buff.append(this.getPaddingString(level - 1));
        Text text = this.getNode().getOwnerDocument().createTextNode(buff.toString());
        this.getNode().appendChild(text);
    }

    protected String getTextContent() {
        StringBuffer buffer = new StringBuffer();
        NodeList list = this.getNode().getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String nodeValue = list.item(i).getNodeValue();
            if (nodeValue != null) {
                buffer.append(nodeValue);
            }
            ++i;
        }
        return buffer.toString().trim();
    }

    protected void setAttribute(String name, String value) {
        if (name == null) {
            return;
        }
        String defaultValue = this.getDefaultValue(name);
        if (defaultValue != null && defaultValue.equals(value)) {
            value = null;
        }
        Node attr = this.getNode().getAttributes().getNamedItem(name);
        if (value == null) {
            if (attr != null) {
                this.getNode().getAttributes().removeNamedItem(name);
            }
        } else if (attr == null) {
            attr = this.getNode().getOwnerDocument().createAttribute(name);
            attr.setNodeValue(value);
            this.getNode().getAttributes().setNamedItem(attr);
        } else if (!value.equals(attr.getNodeValue())) {
            attr.setNodeValue(value);
        }
    }

    protected String getDefaultValue(String attributeName) {
        return null;
    }

    protected String getAttribute(String name) {
        if (name == null) {
            return null;
        }
        String defaultValue = this.getDefaultValue(name);
        Node attr = this.getNode().getAttributes().getNamedItem(name);
        return attr == null ? defaultValue : attr.getNodeValue();
    }

    protected Map getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        NamedNodeMap map = this.getNode().getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Node node = map.item(i);
            result.put(node.getNodeName(), node.getNodeValue());
            ++i;
        }
        return result;
    }

    protected XmlAdapter getAdapter(Node node) {
        return this.getFactory().adapt(node);
    }

    protected void setElement(String elementType, SemanticElement oldElement, SemanticElement newElement) {
        this.removeElement(oldElement);
        this.addElement(newElement);
    }

    protected void removeElement(SemanticElement jpdlElement) {
        if (jpdlElement == null) {
            return;
        }
        XmlAdapter jpdlElementDomAdapter = this.getFactory().getRegisteredAdapterFor(jpdlElement);
        if (jpdlElementDomAdapter != null) {
            jpdlElementDomAdapter.unregister();
            jpdlElement.removePropertyChangeListener(jpdlElementDomAdapter);
            jpdlElementDomAdapter.setSemanticElement(null);
        }
        this.removeElement(jpdlElementDomAdapter);
    }

    protected void addElement(SemanticElement jpdlElement) {
        if (jpdlElement == null) {
            return;
        }
        XmlAdapter jpdlElementDomAdapter = this.getFactory().getRegisteredAdapterFor(jpdlElement);
        if (jpdlElementDomAdapter == null) {
            jpdlElementDomAdapter = this.getFactory().createAdapterFromModel(jpdlElement);
            jpdlElementDomAdapter.setSemanticElement(jpdlElement);
            jpdlElement.addPropertyChangeListener(jpdlElementDomAdapter);
            jpdlElementDomAdapter.register();
        }
        this.addElement(jpdlElementDomAdapter);
    }

    protected void register() {
        this.getFactory().register(this);
    }

    private void unregister() {
        this.getFactory().unregister(this);
        NodeList nodeList = this.getNode().getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            XmlAdapter jpdlElementDomAdapter = this.getAdapter(nodeList.item(i));
            if (jpdlElementDomAdapter != null) {
                jpdlElementDomAdapter.unregister();
            }
            ++i;
        }
    }

    protected void setSemanticElement(SemanticElement semanticElement) {
        this.semanticElement = semanticElement;
    }

    public SemanticElement getSemanticElement() {
        return this.semanticElement;
    }

    protected void setFactory(XmlAdapterFactory factory) {
        this.factory = factory;
    }

    protected XmlAdapterFactory getFactory() {
        return this.factory;
    }

    protected SemanticElementFactory getSemanticElementFactory() {
        return this.factory.getSemanticElementFactory();
    }

    protected XmlAdapterRegistry getXmlAdapterRegistry() {
        return this.factory.getXmlAdapterRegistry();
    }

    public boolean isAdapterForType(Object type) {
        return type == this.getFactory();
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (2 == eventType) {
            this.handleDomAdd(newValue);
        } else if (3 == eventType) {
            this.handleDomRemove(oldValue);
        } else if (changedFeature != null) {
            this.doModelUpdate(((Node)changedFeature).getNodeName(), (String)newValue);
        }
    }

    protected void handleDomAdd(Object newObject) {
        if (!(newObject instanceof INodeNotifier)) {
            return;
        }
        XmlAdapter adapter = (XmlAdapter)this.getFactory().adapt((INodeNotifier)newObject);
        if (adapter != null && adapter.getSemanticElement() == null) {
            this.doModelAdd(adapter);
        }
    }

    protected void handleDomRemove(Object oldObject) {
        if (!(oldObject instanceof INodeNotifier)) {
            return;
        }
        XmlAdapter adapter = (XmlAdapter)this.getFactory().adapt((INodeNotifier)oldObject);
        if (adapter != null) {
            this.doModelRemove(adapter);
        }
    }

    protected abstract void doModelUpdate(String var1, String var2);

    protected abstract void doModelAdd(XmlAdapter var1);

    protected abstract void doModelRemove(XmlAdapter var1);

    public void initialize(SemanticElement jpdlElement) {
        this.setSemanticElement(jpdlElement);
        NodeList nodeList = this.getNode().getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            XmlAdapter jpdlElementDomAdapter = this.getAdapter(nodeList.item(i));
            if (jpdlElementDomAdapter != null && !"#comment".equals(jpdlElementDomAdapter.getNode().getNodeName())) {
                this.doModelAdd(jpdlElementDomAdapter);
            }
            ++i;
        }
        this.register();
    }

    protected SemanticElement createSemanticElementFor(XmlAdapter child) {
        IConfigurationElement configurationElement = this.getXmlAdapterRegistry().getConfigurationElementByXmlNode(child.getNode());
        if (configurationElement == null) {
            return null;
        }
        String id = configurationElement.getAttribute("semanticElement");
        return this.getSemanticElementFactory().createById(id);
    }
}

