/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.registry.RegistryRegistry;
import org.jbpm.gd.common.registry.XmlAdapterRegistry;
import org.jbpm.gd.common.xml.GenericElementXmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterNameProvider;
import org.jbpm.gd.jpdl.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlAdapterFactory
extends AbstractAdapterFactory {
    private SemanticElementFactory semanticElementFactory;
    private XmlAdapterRegistry xmlAdapterRegistry;
    private Map adapterRegistry = new HashMap();
    private Document document;

    public XmlAdapterFactory(Document document, SemanticElementFactory elementFactory) {
        this.document = document;
        this.semanticElementFactory = elementFactory;
        this.xmlAdapterRegistry = RegistryRegistry.getXmlAdapterRegistry(elementFactory.getEditorId());
        this.setAdapterKey((Object)this);
        this.setShouldRegisterAdapter(true);
    }

    public XmlAdapter adapt(Node node) {
        return (XmlAdapter)super.adapt((INodeNotifier)node);
    }

    protected INodeAdapter createAdapter(INodeNotifier target) {
        if (this.document == null) {
            throw new RuntimeException("The document property of the JpdlElementDomAdapterFactory is not initialized");
        }
        XmlAdapter result = null;
        try {
            IConfigurationElement element = this.xmlAdapterRegistry.getConfigurationElementByXmlNode((Node)target);
            if (element != null) {
                result = (XmlAdapter)element.createExecutableExtension("adapterClass");
            } else if (((Node)target).getNodeType() != 3) {
                result = new GenericElementXmlAdapter();
            }
            if (result != null) {
                result.setNode((Node)target);
                result.setFactory(this);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Creation of executable extension failed", e);
        }
        return result;
    }

    private String calculateElementName(IConfigurationElement configurationElement, SemanticElement semanticElement) {
        String nameProviderClass;
        String elementName = configurationElement.getAttribute("xmlElement");
        if (elementName == null && (nameProviderClass = configurationElement.getAttribute("nameProvider")) != null) {
            try {
                XmlAdapterNameProvider nameProvider = (XmlAdapterNameProvider)configurationElement.createExecutableExtension("nameProvider");
                if (nameProvider != null) {
                    elementName = nameProvider.getName(semanticElement);
                }
            }
            catch (CoreException e) {
                Logger.logError("Problem creating nameProvider for " + semanticElement.getElementId(), e);
            }
        }
        return elementName;
    }

    private XmlAdapter createAdapter(IConfigurationElement configurationElement, String elementName) {
        XmlAdapter result = null;
        try {
            result = (XmlAdapter)configurationElement.createExecutableExtension("adapterClass");
            INodeNotifier element = (INodeNotifier)this.document.createElement(elementName);
            element.addAdapter((INodeAdapter)result);
            result.setFactory(this);
            result = (XmlAdapter)this.adapt(element);
            result.setNode((Node)element);
        }
        catch (CoreException e) {
            Logger.logError("Unable to create XML Adapter for " + elementName, e);
        }
        return result;
    }

    public XmlAdapter createAdapterFromModel(SemanticElement semanticElement) {
        IConfigurationElement configurationElement = this.xmlAdapterRegistry.getConfigurationElementBySemanticElementId(semanticElement.getElementId());
        String elementName = this.calculateElementName(configurationElement, semanticElement);
        if (elementName != null) {
            return this.createAdapter(configurationElement, elementName);
        }
        return null;
    }

    void register(XmlAdapter jpdlElementDomAdapter) {
        this.adapterRegistry.put(jpdlElementDomAdapter.getSemanticElement(), jpdlElementDomAdapter);
    }

    void unregister(XmlAdapter jpdlElementDomAdapter) {
        this.adapterRegistry.remove(jpdlElementDomAdapter.getSemanticElement());
    }

    XmlAdapter getRegisteredAdapterFor(SemanticElement jpdlElement) {
        return (XmlAdapter)this.adapterRegistry.get(jpdlElement);
    }

    SemanticElementFactory getSemanticElementFactory() {
        return this.semanticElementFactory;
    }

    XmlAdapterRegistry getXmlAdapterRegistry() {
        return this.xmlAdapterRegistry;
    }
}

