/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.deployment;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.jbpm.gd.jpdl.Logger;

public class IncludeClassesTreeContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object parent) {
        if (parent instanceof IJavaProject) {
            return this.getPackageFragmentRoots((IJavaProject)parent);
        }
        return new Object[0];
    }

    private IPackageFragmentRoot[] getPackageFragmentRoots(IJavaProject project) {
        try {
            ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
            IClasspathEntry[] entries = project.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() != 5) {
                    IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(entries[i]);
                    int j = 0;
                    while (j < roots.length) {
                        list.add(roots[j]);
                        ++j;
                    }
                }
                ++i;
            }
            return list.toArray(new IPackageFragmentRoot[list.size()]);
        }
        catch (JavaModelException e) {
            Logger.logError(e);
            return new IPackageFragmentRoot[0];
        }
    }

    public Object[] getChildren(Object parent) {
        ArrayList list = new ArrayList();
        try {
            if (parent instanceof IPackageFragmentRoot) {
                list.addAll(this.toArrayList(((IPackageFragmentRoot)parent).getNonJavaResources()));
                list.addAll(this.getNonEmptyPackageFragments((IPackageFragmentRoot)parent));
            } else if (parent instanceof IPackageFragment) {
                list.addAll(this.toArrayList(((IPackageFragment)parent).getNonJavaResources()));
                list.addAll(this.toArrayList(((IPackageFragment)parent).getChildren()));
            }
        }
        catch (JavaModelException e) {
            Logger.logError(e);
        }
        return list.toArray();
    }

    private ArrayList toArrayList(Object[] resources) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < resources.length) {
            list.add(resources[i]);
            ++i;
        }
        return list;
    }

    private ArrayList getNonEmptyPackageFragments(IPackageFragmentRoot parent) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Object[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IPackageFragment && this.hasChildren(children, i)) {
                    list.add(children[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.logError(e);
        }
        return list;
    }

    private boolean hasChildren(Object[] children, int i) throws JavaModelException {
        return ((IPackageFragment)children[i]).getChildren().length != 0 || ((IPackageFragment)children[i]).getNonJavaResources().length != 0;
    }

    public Object getParent(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getParent();
        }
        if (element instanceof IResource) {
            IJavaElement javaElement = JavaCore.create((IResource)((IResource)element).getParent());
            if (javaElement != null) {
                return javaElement;
            }
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IPackageFragmentRoot) {
            return this.getChildren(element).length > 0;
        }
        if (element instanceof IPackageFragment) {
            return this.getChildren(element).length > 0;
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.asyncRefresh(viewer);
    }

    private void asyncRefresh(final Viewer viewer) {
        Control control = viewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!viewer.getControl().isDisposed()) {
                        viewer.refresh();
                    }
                }
            });
        }
    }
}

