/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.editor;

import java.util.StringTokenizer;
import org.dom4j.Element;
import org.jbpm.gd.common.editor.AbstractContentProvider;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class JpdlContentProvider
extends AbstractContentProvider {
    protected String getNotationInfoFileName(String semanticInfoFileName) {
        if ("processdefinition.xml".equals(semanticInfoFileName)) {
            return "gpd.xml";
        }
        return super.getNotationInfoFileName(semanticInfoFileName);
    }

    protected String getSemanticInfoFileName(String notationInfoFileName) {
        if ("gpd.xml".equals(notationInfoFileName)) {
            return "processdefinition.xml";
        }
        return super.getSemanticInfoFileName(notationInfoFileName);
    }

    protected void addNodes(NodeContainer nodeContainer, Element notationInfo) {
        NodeElementContainer nodeElementContainer = (NodeElementContainer)nodeContainer.getSemanticElement();
        this.addNodes(nodeContainer, nodeElementContainer.getNodeElements(), notationInfo);
    }

    protected void addEdges(Node node, Element notationInfo) {
        NodeElement nodeElement = (NodeElement)node.getSemanticElement();
        this.addEdges(node, nodeElement.getTransitions(), notationInfo);
    }

    protected SemanticElement getEdgeSemanticElement(Node node, Element notationInfo, int index) {
        Transition[] transitions = ((NodeElement)node.getSemanticElement()).getTransitions();
        return index < transitions.length ? transitions[index] : null;
    }

    protected SemanticElement getNodeSemanticElement(NodeContainer nodeContainer, Element notationInfo, int index) {
        NodeElementContainer nodeElementContainer = (NodeElementContainer)nodeContainer.getSemanticElement();
        return nodeElementContainer.getNodeElementByName(notationInfo.attributeValue("name"));
    }

    protected SemanticElement findDestination(Edge edge, Node source) {
        NodeContainer notationElement = source.getContainer();
        String pathCopy = ((Transition)edge.getSemanticElement()).getTo();
        while (pathCopy.length() > 3 && "../".equals(pathCopy.substring(0, 3)) && notationElement != null) {
            notationElement = ((Node)((Object)notationElement)).getContainer();
            pathCopy = pathCopy.substring(3);
        }
        if (notationElement == null) {
            return null;
        }
        SemanticElement parent = notationElement.getSemanticElement();
        StringTokenizer tokenizer = new StringTokenizer(pathCopy, "/");
        while (parent != null && tokenizer.hasMoreTokens()) {
            if (!(parent instanceof NodeElementContainer)) {
                return null;
            }
            parent = ((NodeElementContainer)parent).getNodeElementByName(tokenizer.nextToken());
        }
        return (NodeElement)parent;
    }
}

