/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.notation;

import java.beans.PropertyChangeEvent;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessDefinition;

public class JpdlEdge
extends Edge {
    public Label getLabel() {
        Label result = super.getLabel();
        if (result == null) {
            result = (Label)this.getFactory().create("org.jbpm.gd.jpdl.label");
            this.addPropertyChangeListener(result);
            this.setLabel(result);
        }
        return result;
    }

    public void setSemanticElement(SemanticElement semanticElement) {
        super.setSemanticElement(semanticElement);
        this.getLabel().setSemanticElement(semanticElement);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("to")) {
            Node targetNode;
            Node oldTargetNode;
            if (this.getSource() == null) {
                return;
            }
            ProcessDefinition processDefinition = (ProcessDefinition)this.getSource().getContainer().getSemanticElement();
            NodeElement newTarget = processDefinition.getNodeElementByName((String)evt.getNewValue());
            NodeElement oldTarget = processDefinition.getNodeElementByName((String)evt.getOldValue());
            if (oldTarget != null && (oldTargetNode = (Node)this.getRegisteredNotationElementFor(oldTarget)) != null) {
                oldTargetNode.removeArrivingEdge(this);
            }
            if (newTarget != null && (targetNode = (Node)this.getRegisteredNotationElementFor(newTarget)) != null) {
                targetNode.addArrivingEdge(this);
            }
        } else {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

