/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.notation;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.StringTokenizer;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class JpdlNode
extends Node {
    public void propertyChange(PropertyChangeEvent evt) {
        Transition transition;
        Edge edge;
        String eventName = evt.getPropertyName();
        if (eventName.equals("name")) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            List edges = this.getArrivingEdges();
            int i = 0;
            while (i < edges.size()) {
                Edge edge2 = (Edge)edges.get(i);
                edge2.getSemanticElement().removePropertyChangeListener(edge2);
                ((Transition)edge2.getSemanticElement()).setTo((String)evt.getNewValue());
                edge2.getSemanticElement().addPropertyChangeListener(edge2);
                ++i;
            }
        } else if (eventName.equals("transitionAdd")) {
            Transition transition2 = (Transition)evt.getNewValue();
            Edge edge3 = (Edge)this.getRegisteredNotationElementFor(transition2);
            if (edge3 == null) {
                CreationFactory factory = new CreationFactory(transition2.getElementId(), this.getSemanticElement().getFactory(), this.getFactory());
                edge3 = (Edge)factory.getNewObject();
            }
            this.addLeavingEdge(edge3);
            transition2.addPropertyChangeListener(edge3);
            Node targetNode = this.getDestinationNode(transition2.getTo());
            if (targetNode != null) {
                targetNode.addArrivingEdge(edge3);
            }
        } else if (eventName.equals("transitionRemove") && (edge = (Edge)this.getRegisteredNotationElementFor(transition = (Transition)evt.getOldValue())) != null) {
            Node targetNode = edge.getTarget();
            if (targetNode != null) {
                transition.removePropertyChangeListener(edge);
                targetNode.removeArrivingEdge(edge);
            }
            this.removeLeavingEdge(edge);
        }
    }

    private Node getDestinationNode(String to) {
        NotationElement runner = this.getContainer();
        SemanticElement jpdlElement = null;
        StringTokenizer tokenizer = new StringTokenizer(to, "/");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if ("..".equals(nextToken)) {
                if (runner != null && runner instanceof Node) {
                    runner = ((Node)runner).getContainer();
                    continue;
                }
                runner = null;
                break;
            }
            if (jpdlElement == null) {
                jpdlElement = runner.getSemanticElement();
            }
            if (jpdlElement instanceof NodeElementContainer) {
                jpdlElement = ((NodeElementContainer)jpdlElement).getNodeElementByName(nextToken);
                runner = (Node)this.getRegisteredNotationElementFor(jpdlElement);
                continue;
            }
            runner = null;
            break;
        }
        return (Node)runner;
    }
}

