/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.notation;

import java.beans.PropertyChangeEvent;
import java.util.StringTokenizer;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNodeContainer;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class JpdlNodeContainer
extends AbstractNodeContainer {
    public void propertyChange(PropertyChangeEvent evt) {
        Transition transition;
        Edge edge;
        String eventName = evt.getPropertyName();
        if (eventName.equals("nodeElementAdd")) {
            SemanticElement jpdlElement = (SemanticElement)evt.getNewValue();
            AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(jpdlElement);
            if (notationElement == null) {
                CreationFactory factory = new CreationFactory(jpdlElement.getElementId(), jpdlElement.getFactory(), this.getFactory());
                notationElement = (AbstractNotationElement)factory.getNewObject();
            }
            this.addNode((Node)notationElement);
            jpdlElement.addPropertyChangeListener(notationElement);
        } else if (eventName.equals("nodeElementRemove")) {
            SemanticElement jpdlElement = (SemanticElement)evt.getOldValue();
            AbstractNotationElement notationElement = this.getRegisteredNotationElementFor(jpdlElement);
            if (notationElement != null) {
                jpdlElement.removePropertyChangeListener(notationElement);
                this.removeNode((Node)notationElement);
            }
        } else if (eventName.equals("transitionAdd")) {
            Transition transition2 = (Transition)evt.getNewValue();
            Edge edge2 = (Edge)this.getRegisteredNotationElementFor(transition2);
            if (edge2 == null) {
                CreationFactory factory = new CreationFactory(transition2.getElementId(), this.getSemanticElement().getFactory(), this.getFactory());
                edge2 = (Edge)factory.getNewObject();
            }
            this.addLeavingEdge(edge2);
            transition2.addPropertyChangeListener(edge2);
            Node targetNode = this.getDestinationNode(transition2.getTo());
            if (targetNode != null) {
                targetNode.addArrivingEdge(edge2);
            }
        } else if (eventName.equals("transitionRemove") && (edge = (Edge)this.getRegisteredNotationElementFor(transition = (Transition)evt.getOldValue())) != null) {
            Node targetNode = edge.getTarget();
            if (targetNode != null) {
                transition.removePropertyChangeListener(edge);
                targetNode.removeArrivingEdge(edge);
            }
            this.removeLeavingEdge(edge);
        }
    }

    private Node getDestinationNode(String to) {
        NotationElement runner = this.getContainer();
        SemanticElement jpdlElement = null;
        StringTokenizer tokenizer = new StringTokenizer(to, "/");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if ("..".equals(nextToken)) {
                if (runner != null && runner instanceof Node) {
                    runner = ((Node)runner).getContainer();
                    continue;
                }
                runner = null;
                break;
            }
            if (jpdlElement == null) {
                jpdlElement = runner.getSemanticElement();
            }
            if (jpdlElement instanceof NodeElementContainer) {
                jpdlElement = ((NodeElementContainer)jpdlElement).getNodeElementByName(nextToken);
                runner = (Node)this.getRegisteredNotationElementFor(jpdlElement);
                continue;
            }
            runner = null;
            break;
        }
        return (Node)runner;
    }
}

