/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.prefs;

import java.io.File;
import java.net.MalformedURLException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.prefs.PreferencesManager;

public class AddJbpmInstallationDialog
extends StatusDialog {
    private static final String pluginId = Plugin.getDefault().getBundle().getSymbolicName();
    private static final IStatus enterNameStatus = new Status(1, pluginId, 0, "Enter the name of the jBPM installation.", null);
    private static final IStatus enterLocationStatus = new Status(1, pluginId, 0, "Enter the location of the jBPM installation.", null);
    private static final IStatus unExistingLocationStatus = new Status(4, pluginId, 0, "The location does not exist.", null);
    private static final IStatus nameAlreadyUsedStatus = new Status(4, pluginId, 0, "The name is already used.", null);
    private static final IStatus inValidJbpmInstallationStatus = new Status(4, pluginId, 0, "This is not a valid jBPM installation.", null);
    String title;
    Text nameText;
    Text locationText;
    Button locationButton;
    IStatus currentStatus = enterNameStatus;
    String name;
    String location;
    IStatus status;

    public AddJbpmInstallationDialog(Shell parentShell) {
        super(parentShell);
    }

    public void initialize(String t, String n, String l) {
        this.title = t;
        this.name = n;
        this.location = l;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        area.setLayout((Layout)gridLayout);
        this.createNameLabel(area);
        this.createNameText(area);
        this.createFillLabel(area);
        this.createLocationLabel(area);
        this.createLocationText(area);
        this.createLocationButton(area);
        this.getShell().setText(this.title);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.updateStatus(this.currentStatus);
        return result;
    }

    private void createLocationText(Composite area) {
        this.locationText = new Text(area, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.locationText.setLayoutData((Object)gridData);
        this.locationText.setText(this.location == null ? "" : this.location);
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJbpmInstallationDialog.this.handleLocationChanged();
            }
        });
    }

    private void handleLocationChanged() {
        this.location = this.locationText.getText();
        this.updateCurrentStatus();
        this.updateStatus(this.currentStatus);
    }

    private void createLocationButton(Composite area) {
        this.locationButton = new Button(area, 8);
        this.locationButton.setText("Search...");
        this.locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJbpmInstallationDialog.this.searchLocation();
            }
        });
    }

    private void searchLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        String result = dialog.open();
        if (result != null) {
            this.locationText.setText(result);
        }
    }

    private void createLocationLabel(Composite area) {
        Label label = new Label(area, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText("Location :");
    }

    private void createFillLabel(Composite area) {
        new Label(area, 0);
    }

    private void createNameText(Composite area) {
        this.nameText = new Text(area, 2048);
        GridData gridData = new GridData();
        gridData.verticalIndent = 10;
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.setText(this.name == null ? "" : this.name);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJbpmInstallationDialog.this.handleNameChanged();
            }
        });
    }

    private void handleNameChanged() {
        this.name = this.nameText.getText();
        this.updateCurrentStatus();
        this.updateStatus(this.currentStatus);
    }

    private void updateCurrentStatus() {
        this.currentStatus = this.isNameEmpty() && this.isLocationEmpty() ? enterNameStatus : (this.isNameAlreadyUsed() && !"Edit Location".equals(this.title) ? nameAlreadyUsedStatus : (this.isLocationEmpty() ? enterLocationStatus : (!this.isLocationExisting() ? unExistingLocationStatus : (!this.isValidJbpmInstallation() ? inValidJbpmInstallationStatus : (this.isNameEmpty() ? enterNameStatus : Status.OK_STATUS)))));
    }

    private boolean isNameAlreadyUsed() {
        return PreferencesManager.INSTANCE.getJbpmInstallation(this.nameText.getText()) != null;
    }

    private boolean isLocationExisting() {
        return new Path(this.location).toFile().exists();
    }

    private boolean isNameEmpty() {
        return this.name == null || "".equals(this.name);
    }

    private boolean isLocationEmpty() {
        return this.location == null || "".equals(this.location);
    }

    private boolean isValidJbpmInstallation() {
        return this.getJbpmVersionInfoFile().exists();
    }

    private File getJbpmVersionInfoFile() {
        return new Path(this.location).append("/src/resources/gpd/version.info.xml").toFile();
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    private void createNameLabel(Composite area) {
        Label label = new Label(area, 0);
        GridData gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        label.setText("Name :");
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        String result = "3.1";
        try {
            Document document = new SAXReader().read(this.getJbpmVersionInfoFile());
            result = document.getRootElement().attribute("name").getValue();
        }
        catch (DocumentException documentException) {
        }
        catch (MalformedURLException malformedURLException) {}
        return result;
    }
}

