/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.prefs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jbpm.gd.jpdl.Constants;
import org.jbpm.gd.jpdl.Plugin;

public class ServerDeploymentPage
extends PreferencePage
implements IWorkbenchPreferencePage,
Constants {
    private Text nameText;
    private Text portText;
    private Text deployerText;

    public ServerDeploymentPage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite clientArea = this.createClientArea(parent);
        this.createNameField(clientArea);
        this.createPortField(clientArea);
        this.createDeployerField(clientArea);
        return null;
    }

    private void createNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Server name:");
        this.nameText = new Text(parent, 2048);
        String serverName = this.getPreferenceStore().getString("server name");
        this.nameText.setText(serverName == null || "".equals(serverName) ? "localhost" : serverName);
        this.nameText.setLayoutData((Object)new GridData(768));
    }

    private void createPortField(Composite parent) {
        Label portLabel = new Label(parent, 0);
        portLabel.setText("Server port:");
        this.portText = new Text(parent, 2048);
        String serverPort = this.getPreferenceStore().getString("server port");
        this.portText.setText(serverPort == null || "".equals(serverPort) ? "8080" : serverPort);
        this.portText.setLayoutData((Object)new GridData(768));
    }

    private void createDeployerField(Composite parent) {
        Label deployerLabel = new Label(parent, 0);
        deployerLabel.setText("Server deployer:");
        this.deployerText = new Text(parent, 2048);
        String serverDeployer = this.getPreferenceStore().getString("server deployer");
        this.deployerText.setText(serverDeployer == null || "".equals(serverDeployer) ? "/jbpm-console/upload" : serverDeployer);
        this.deployerText.setLayoutData((Object)new GridData(768));
    }

    private Composite createClientArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        clientArea.setLayoutData((Object)gridData);
        return clientArea;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("server name", this.nameText.getText());
        this.getPreferenceStore().setValue("server port", this.portText.getText());
        this.getPreferenceStore().setValue("server deployer", this.deployerText.getText());
        return true;
    }

    public void performDefaults() {
        this.nameText.setText("localhost");
        this.portText.setText("8080");
        this.deployerText.setText("jbpm-console/upload");
        this.getPreferenceStore().setValue("server name", "localhost");
        this.getPreferenceStore().setValue("server port", "8080");
        this.getPreferenceStore().setValue("server deployer", "jbpm-console/upload");
    }
}

