/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.properties.ActionAdvancedConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ActionDetailsConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ActionNameConfigurationComposite;

public class ActionConfigurationComposite {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Action action;
    private CTabFolder actionTabFolder;
    private ActionNameConfigurationComposite actionNameConfigurationComposite;
    private ActionDetailsConfigurationComposite actionDetailsConfigurationComposite;
    private ActionAdvancedConfigurationComposite actionAdvancedConfigurationComposite;

    public static ActionConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ActionConfigurationComposite result = new ActionConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setAction(Action action) {
        if (this.action == action) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.action = action;
        if (action != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public Action getAction() {
        return this.action;
    }

    private void unhookListeners() {
    }

    private void hookListeners() {
    }

    private void clearControls() {
        this.actionNameConfigurationComposite.setAction(null);
        this.actionDetailsConfigurationComposite.setAction(null);
        this.actionAdvancedConfigurationComposite.setAction(null);
    }

    private void updateControls() {
        this.actionNameConfigurationComposite.setAction(this.action);
        this.actionDetailsConfigurationComposite.setAction(this.action);
        this.actionAdvancedConfigurationComposite.setAction(this.action);
    }

    private void create() {
        this.actionTabFolder = this.widgetFactory.createTabFolder(this.parent, 2176);
        this.actionTabFolder.setLayoutData((Object)this.createActionTabFolderLayoutData());
        this.createGeneralTabItem();
        this.createDetailsTabItem();
        this.createAdvancedTabItem();
        this.actionTabFolder.setSelection(0);
    }

    private void createGeneralTabItem() {
        CTabItem generalTabItem = this.widgetFactory.createTabItem(this.actionTabFolder, 0);
        generalTabItem.setText("General");
        Composite generalTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.actionTabFolder);
        this.actionNameConfigurationComposite = ActionNameConfigurationComposite.create(this.widgetFactory, generalTabControl);
        generalTabItem.setControl((Control)generalTabControl);
    }

    private void createDetailsTabItem() {
        CTabItem detailsTabItem = this.widgetFactory.createTabItem(this.actionTabFolder, 0);
        detailsTabItem.setText("Details");
        Composite detailsTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.actionTabFolder);
        this.actionDetailsConfigurationComposite = ActionDetailsConfigurationComposite.create(this.widgetFactory, detailsTabControl);
        detailsTabItem.setControl((Control)detailsTabControl);
    }

    private void createAdvancedTabItem() {
        CTabItem advancedTabItem = this.widgetFactory.createTabItem(this.actionTabFolder, 0);
        advancedTabItem.setText("Advanced");
        Composite advancedTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.actionTabFolder);
        this.actionAdvancedConfigurationComposite = ActionAdvancedConfigurationComposite.create(this.widgetFactory, advancedTabControl);
        advancedTabItem.setControl((Control)advancedTabControl);
    }

    private FormData createActionTabFolderLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.top = new FormAttachment(0, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }
}

