/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Event;

public class EventConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label eventTypeLabel;
    private CCombo eventTypeCombo;
    private Event event;

    public static EventConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        EventConfigurationComposite result = new EventConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private EventConfigurationComposite() {
    }

    public void setEvent(Event event) {
        if (this.event == event) {
            return;
        }
        this.unhookListeners();
        this.event = event;
        if (event == null) {
            this.clearControls();
        } else {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.eventTypeCombo.addSelectionListener((SelectionListener)this);
        this.eventTypeCombo.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.eventTypeCombo.removeSelectionListener((SelectionListener)this);
        this.eventTypeCombo.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.eventTypeCombo.setText("");
    }

    private void updateControls() {
        String type = this.event.getType();
        if (type != null) {
            this.eventTypeCombo.setText(type);
        } else {
            this.eventTypeCombo.setText("");
        }
    }

    private void create() {
        this.eventTypeLabel = this.widgetFactory.createLabel(this.parent, "Event Type");
        this.eventTypeCombo = this.widgetFactory.createCCombo(this.parent);
        this.eventTypeCombo.setItems(Event.PREDEFINED_EVENT_TYPES);
        this.eventTypeCombo.setText("");
        this.eventTypeLabel.setLayoutData((Object)this.createEventTypeLabelLayoutData());
        this.eventTypeCombo.setLayoutData((Object)this.createEventTypeComboLayoutData());
    }

    private FormData createEventTypeComboLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.eventTypeLabel, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createEventTypeLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 3);
        return data;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.eventTypeCombo) {
            this.event.setType(this.eventTypeCombo.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.eventTypeCombo) {
            this.event.setType(this.eventTypeCombo.getText());
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.eventTypeCombo) {
            this.event.setType(this.eventTypeCombo.getText());
        }
    }
}

