/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Node;
import org.jbpm.gd.jpdl.properties.ActionConfigurationComposite;

public class NodeActionSection
extends AbstractPropertySection {
    private ActionConfigurationComposite actionConfigurationComposite;
    private Node node;
    private Button configureActionButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
        this.configureActionButton = this.getWidgetFactory().createButton(clientArea, "Configure Action", 32);
        this.configureActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeActionSection.this.handleConfigureActionButtonSelected();
            }
        });
        Composite actionInfoArea = this.getWidgetFactory().createComposite(clientArea);
        actionInfoArea.setLayout((Layout)new FormLayout());
        this.actionConfigurationComposite = ActionConfigurationComposite.create(this.getWidgetFactory(), actionInfoArea);
        this.configureActionButton.setLayoutData((Object)this.createConfigureActionButtonLayoutData());
        actionInfoArea.setLayoutData((Object)this.createActionInfoAreaLayoutData());
    }

    private void handleConfigureActionButtonSelected() {
        if (this.node != null) {
            if (this.configureActionButton.getSelection()) {
                this.node.setAction((Action)this.node.getFactory().createById("org.jbpm.gd.jpdl.action"));
            } else {
                this.node.setAction(null);
            }
        }
        this.refresh();
    }

    private FormData createConfigureActionButtonLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 5);
        result.top = new FormAttachment(0, 5);
        return result;
    }

    private FormData createActionInfoAreaLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment((Control)this.configureActionButton, 5);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            input = notationElement.getSemanticElement();
        } else if (input instanceof OutlineEditPart) {
            input = ((OutlineEditPart)input).getModel();
        }
        if (input instanceof Node) {
            this.node = (Node)input;
            this.refresh();
        }
    }

    public void refresh() {
        if (this.node == null) {
            this.configureActionButton.setSelection(false);
            this.actionConfigurationComposite.setAction(null);
        } else {
            this.configureActionButton.setSelection(this.node.getAction() != null);
            this.actionConfigurationComposite.setAction(this.node.getAction());
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

