/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.properties.ActionConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ScriptConfigurationComposite;

public class TimerActionConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label actionTypeLabel;
    private CCombo actionTypeCombo;
    private Composite actionComposite;
    private Composite scriptComposite;
    private ActionConfigurationComposite actionConfigurationComposite;
    private ScriptConfigurationComposite scriptConfigurationComposite;
    private Timer timer;

    public static TimerActionConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        TimerActionConfigurationComposite result = new TimerActionConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private TimerActionConfigurationComposite() {
    }

    public void setTimer(Timer timer) {
        if (this.timer == timer) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.timer = timer;
        if (timer != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.actionTypeCombo.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.actionTypeCombo.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.actionTypeCombo.setText("<None>");
        this.actionComposite.setVisible(false);
        this.scriptComposite.setVisible(false);
    }

    private void updateControls() {
        if (this.timer.getScript() != null) {
            this.actionTypeCombo.setText("Script");
            this.scriptConfigurationComposite.setScript(this.timer.getScript());
            this.scriptComposite.setVisible(true);
        } else if (this.timer.getAction() != null) {
            this.actionTypeCombo.setText("Action");
            this.actionConfigurationComposite.setAction(this.timer.getAction());
            this.actionComposite.setVisible(true);
        } else {
            this.actionTypeCombo.setText("<None>");
        }
    }

    private void create() {
        this.actionTypeLabel = this.widgetFactory.createLabel(this.parent, "Action Type");
        this.actionTypeCombo = this.widgetFactory.createCCombo(this.parent);
        this.actionTypeCombo.setItems(new String[]{"<None>", "Action", "Script"});
        this.actionTypeCombo.addSelectionListener((SelectionListener)this);
        this.actionComposite = this.widgetFactory.createComposite(this.parent);
        this.actionComposite.setLayout((Layout)new FormLayout());
        this.actionConfigurationComposite = ActionConfigurationComposite.create(this.widgetFactory, this.actionComposite);
        this.actionComposite.setVisible(false);
        this.scriptComposite = this.widgetFactory.createComposite(this.parent);
        this.scriptComposite.setLayout((Layout)new FormLayout());
        this.scriptConfigurationComposite = ScriptConfigurationComposite.create(this.widgetFactory, this.scriptComposite);
        this.scriptComposite.setVisible(false);
        this.actionTypeLabel.setLayoutData((Object)this.createActionTypeLabelLayoutData());
        this.actionTypeCombo.setLayoutData((Object)this.createActionTypeComboLayoutData());
        this.actionComposite.setLayoutData((Object)this.createActionCompositeLayoutData());
        this.scriptComposite.setLayoutData((Object)this.createActionCompositeLayoutData());
    }

    private FormData createActionCompositeLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.actionTypeCombo, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private FormData createActionTypeComboLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.actionTypeLabel, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createActionTypeLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.actionTypeCombo) {
            this.handleActionTypeComboSelected();
        }
    }

    private void handleActionTypeComboSelected() {
        if ("Action".equals(this.actionTypeCombo.getText())) {
            if (this.actionConfigurationComposite.getAction() == null) {
                this.actionConfigurationComposite.setAction((Action)this.timer.getFactory().createById("org.jbpm.gd.jpdl.action"));
            }
            this.timer.setScript(null);
            this.timer.setAction(this.actionConfigurationComposite.getAction());
        } else if ("Script".equals(this.actionTypeCombo.getText())) {
            if (this.scriptConfigurationComposite.getScript() == null) {
                this.scriptConfigurationComposite.setScript((Script)this.timer.getFactory().createById("org.jbpm.gd.jpdl.script"));
            }
            this.timer.setAction(null);
            this.timer.setScript(this.scriptConfigurationComposite.getScript());
        } else {
            this.timer.setScript(null);
            this.timer.setAction(null);
        }
        this.actionComposite.setVisible("Action".equals(this.actionTypeCombo.getText()));
        this.scriptComposite.setVisible("Script".equals(this.actionTypeCombo.getText()));
    }
}

