/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.TimerContainer;
import org.jbpm.gd.jpdl.properties.TimerConfigurationComposite;
import org.jbpm.gd.jpdl.properties.TimerContainerSectionActionBarContributor;

public class TimerContainerSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private TimerContainer timerContainer;
    private Timer selectedTimer;
    private TimerContainerSectionActionBarContributor actionBarContributor;
    private Table timerTable;
    private Composite detailsArea;
    private TimerConfigurationComposite timerConfigurationComposite;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.actionBarContributor = new TimerContainerSectionActionBarContributor(this);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createMasterArea(composite);
        this.createDetailsArea(composite);
    }

    private void createMasterArea(Composite composite) {
        this.timerTable = this.getWidgetFactory().createTable(composite, 68356);
        this.timerTable.setLayoutData((Object)this.createTimerTableLayoutData());
        this.timerTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimerContainerSection.this.handleTimerTableSelected();
            }
        });
        this.actionBarContributor.createPopupMenu((Composite)this.timerTable);
    }

    private void createDetailsArea(Composite composite) {
        this.detailsArea = this.getWidgetFactory().createComposite(composite);
        this.detailsArea.setLayout((Layout)new FormLayout());
        this.detailsArea.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.detailsArea.setVisible(false);
        this.timerConfigurationComposite = TimerConfigurationComposite.create(this.getWidgetFactory(), this.detailsArea);
    }

    private void handleTimerTableSelected() {
        TableItem[] selectedItems = this.timerTable.getSelection();
        if (selectedItems.length == 0) {
            this.unSelectAll();
        } else {
            this.selectTimer((Timer)selectedItems[0].getData());
        }
        this.detailsArea.setVisible(selectedItems.length != 0);
    }

    private void clearControls() {
        this.timerTable.removeAll();
        this.timerConfigurationComposite.setTimer(null);
        this.detailsArea.setVisible(false);
    }

    private void selectTimer(Timer timer) {
        if (timer == this.selectedTimer) {
            return;
        }
        this.actionBarContributor.setRemoveEnabled(timer != null);
        if (this.selectedTimer != null) {
            this.selectedTimer.removePropertyChangeListener(this);
        }
        this.selectedTimer = timer;
        this.updateTimerDetails();
        if (this.selectedTimer != null) {
            this.selectedTimer.addPropertyChangeListener(this);
        }
    }

    private void updateTimerDetails() {
        this.timerConfigurationComposite.setTimer(this.selectedTimer);
    }

    private FormData createTimerTableLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private FormData createDetailsAreaLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.timerTable, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            this.setTimerContainer((TimerContainer)notationElement.getSemanticElement());
        } else if (input instanceof OutlineEditPart) {
            this.setTimerContainer((TimerContainer)((OutlineEditPart)input).getModel());
        }
    }

    private void setTimerContainer(TimerContainer newTimerContainer) {
        if (this.timerContainer == newTimerContainer) {
            return;
        }
        if (this.timerContainer != null) {
            this.timerContainer.removePropertyChangeListener(this);
        }
        this.clearControls();
        this.timerContainer = newTimerContainer;
        if (this.timerContainer != null) {
            this.updateTimerTable();
            this.timerContainer.addPropertyChangeListener(this);
        }
    }

    private void unSelectAll() {
        if (this.selectedTimer != null) {
            this.selectTimer(null);
        }
    }

    private void updateTimerTable() {
        Timer[] timers = this.timerContainer.getTimers();
        int i = 0;
        while (i < timers.length) {
            TableItem tableItem = new TableItem(this.timerTable, 0);
            tableItem.setText(this.getLabel(timers[i]));
            tableItem.setData((Object)timers[i]);
            tableItem.setImage(SharedImages.INSTANCE.getImage(timers[i].getIconDescriptor()));
            ++i;
        }
    }

    private String getLabel(Timer timer) {
        String result = timer.getName();
        if (result != null && !"".equals(result)) {
            return result;
        }
        result = timer.getLabel();
        return result != null ? result.toLowerCase() : timer.getElementId();
    }

    public TabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.tabbedPropertySheetPage;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.timerTable.isDisposed()) {
            return;
        }
        if ("timerAdd".equals(evt.getPropertyName())) {
            TableItem tableItem = new TableItem(this.timerTable, 0);
            Timer timer = (Timer)evt.getNewValue();
            tableItem.setText(this.getLabel(timer));
            tableItem.setData((Object)timer);
            tableItem.setImage(SharedImages.INSTANCE.getImage(timer.getIconDescriptor()));
            this.timerTable.setSelection(tableItem);
            this.timerTable.notifyListeners(13, new Event());
        } else if ("actionElementRemove".equals(evt.getPropertyName())) {
            TableItem tableItem = this.getItemToRemove(evt.getOldValue());
            if (tableItem != null) {
                tableItem.dispose();
                this.timerTable.notifyListeners(13, new Event());
            }
        } else if ("name".equals(evt.getPropertyName()) || "refName".equals(evt.getPropertyName())) {
            TableItem tableItem = this.timerTable.getSelection()[0];
            tableItem.setText(this.getLabel((Timer)tableItem.getData()));
        }
    }

    private TableItem getItemToRemove(Object object) {
        int i = 0;
        while (i < this.timerTable.getItemCount()) {
            if (this.timerTable.getItem(i).getData() == object) {
                return this.timerTable.getItem(i);
            }
            ++i;
        }
        return null;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void aboutToBeShown() {
        this.actionBarContributor.activateContributions();
    }

    public void aboutToBeHidden() {
        this.actionBarContributor.deactivateContributions();
    }

    public TimerContainer getTimerContainer() {
        return this.timerContainer;
    }

    public Timer getSelectedTimer() {
        return this.selectedTimer;
    }
}

