/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Timer;

public class TimerGeneralConfigurationComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label nameLabel;
    private Text nameText;
    private Label transitionLabel;
    private Text transitionText;
    private Label duedateLabel;
    private Text duedateText;
    private Label repeatLabel;
    private Text repeatText;
    private Timer timer;

    public static TimerGeneralConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        TimerGeneralConfigurationComposite result = new TimerGeneralConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setTimer(Timer timer) {
        if (this.timer == timer) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.timer = timer;
        if (timer != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.nameText.addFocusListener((FocusListener)this);
        this.transitionText.addFocusListener((FocusListener)this);
        this.duedateText.addFocusListener((FocusListener)this);
        this.repeatText.addFocusListener((FocusListener)this);
    }

    private void unhookSelectionListener() {
        this.nameText.removeFocusListener((FocusListener)this);
        this.transitionText.removeFocusListener((FocusListener)this);
        this.duedateText.removeFocusListener((FocusListener)this);
        this.repeatText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.nameText.setText("");
        this.transitionText.setText("");
        this.duedateText.setText("");
        this.repeatText.setText("");
    }

    private void updateControls() {
        this.nameText.setText(this.timer.getName() == null ? "" : this.timer.getName());
        this.transitionText.setText(this.timer.getTransition() == null ? "" : this.timer.getTransition());
        this.duedateText.setText(this.timer.getDueDate() == null ? "" : this.timer.getDueDate());
        this.repeatText.setText(this.timer.getRepeat() == null ? "" : this.timer.getRepeat());
    }

    private void create() {
        this.nameLabel = this.widgetFactory.createLabel(this.parent, "Name");
        this.nameText = this.widgetFactory.createText(this.parent, "");
        this.transitionLabel = this.widgetFactory.createLabel(this.parent, "Transition");
        this.transitionText = this.widgetFactory.createText(this.parent, "");
        this.duedateLabel = this.widgetFactory.createLabel(this.parent, "Due Date");
        this.duedateText = this.widgetFactory.createText(this.parent, "");
        this.repeatLabel = this.widgetFactory.createLabel(this.parent, "Repeat");
        this.repeatText = this.widgetFactory.createText(this.parent, "");
        this.nameLabel.setLayoutData((Object)this.createNameLabelLayoutData());
        this.nameText.setLayoutData((Object)this.createNameTextLayoutData());
        this.transitionLabel.setLayoutData((Object)this.createTransitionLabelLayoutData());
        this.transitionText.setLayoutData((Object)this.createTransitionTextLayoutData());
        this.duedateLabel.setLayoutData((Object)this.createDuedateLabelLayoutData());
        this.duedateText.setLayoutData((Object)this.createDuedateTextLayoutData());
        this.repeatLabel.setLayoutData((Object)this.createRepeatLabelLayoutData());
        this.repeatText.setLayoutData((Object)this.createRepeatTextLayoutData());
    }

    private FormData createNameTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createNameLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 7);
        return data;
    }

    private FormData createTransitionLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.nameText, 2);
        return data;
    }

    private FormData createTransitionTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.nameText, 0);
        return data;
    }

    private FormData createDuedateLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.transitionText, 2);
        return data;
    }

    private FormData createDuedateTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.transitionText, 0);
        return data;
    }

    private FormData createRepeatLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.duedateText, 2);
        return data;
    }

    private FormData createRepeatTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.duedateText, 0);
        return data;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.nameText) {
            this.timer.setName("".equals(this.nameText.getText()) ? null : this.nameText.getText());
        } else if (e.widget == this.transitionText) {
            this.timer.setTransition("".equals(this.transitionText.getText()) ? null : this.transitionText.getText());
        } else if (e.widget == this.duedateText) {
            this.timer.setDueDate("".equals(this.duedateText.getText()) ? null : this.duedateText.getText());
        } else if (e.widget == this.repeatText) {
            this.timer.setRepeat("".equals(this.repeatText.getText()) ? null : this.repeatText.getText());
        }
    }
}

