/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.taskform;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.jbpm.gd.jpdl.taskform.Button;
import org.jbpm.gd.jpdl.taskform.Field;

public class FormGenerator {
    public static final int BUFFERSIZE = 4096;
    public static final String NEWLINE = System.getProperty("line.separator");

    public static String getForm(List fields, List buttons) {
        String form = FormGenerator.getTemplateString();
        String fieldRowsText = FormGenerator.buildFieldRows(fields);
        form = FormGenerator.insert(form, "<!-- TASKFORM ROWS -->", fieldRowsText);
        String buttonsText = FormGenerator.buildButtons(buttons);
        form = FormGenerator.insert(form, "<!-- TASKFORM BUTTONS -->", buttonsText);
        return form.toString();
    }

    public static String insert(String source, String marker, String value) {
        int index = source.indexOf(marker);
        if (index == -1) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(source.substring(0, index += marker.length()));
        buffer.append(value);
        buffer.append(source.substring(index + 1));
        return buffer.toString();
    }

    private static String buildFieldRows(List fields) {
        if (fields == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(NEWLINE);
        for (Field field : fields) {
            buffer.append("    <jbpm:datacell>");
            buffer.append(NEWLINE);
            buffer.append("      <f:facet name=\"header\">");
            buffer.append(NEWLINE);
            buffer.append("        <h:outputText value=\"");
            buffer.append(field.getLabel());
            buffer.append("\"/>");
            buffer.append(NEWLINE);
            buffer.append("      </f:facet>");
            buffer.append(NEWLINE);
            buffer.append("      " + field.getFieldType().render(field));
            buffer.append(NEWLINE);
            buffer.append("    </jbpm:datacell>");
            buffer.append(NEWLINE);
        }
        return buffer.toString();
    }

    private static String buildButtons(List buttons) {
        if (buttons == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(NEWLINE);
        Iterator iter = buttons.iterator();
        while (iter.hasNext()) {
            Button button = (Button)iter.next();
            buffer.append("      ");
            buffer.append(button.getXhtml());
            if (!iter.hasNext()) continue;
            buffer.append(NEWLINE);
        }
        return buffer.toString();
    }

    public static String getTemplateString() {
        StringBuffer formTemplate = new StringBuffer();
        String resource = "form.template.xhtml";
        InputStream inputStream = FormGenerator.class.getResourceAsStream(resource);
        if (inputStream == null) {
            throw new RuntimeException("couldn't get resource " + resource + " for form template");
        }
        try {
            InputStreamReader reader = new InputStreamReader(inputStream);
            char[] chars = new char[4096];
            int charsRead = reader.read(chars);
            while (charsRead != -1) {
                formTemplate.append(chars, 0, charsRead);
                charsRead = reader.read(chars);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't read form template", e);
        }
        return formTemplate.toString();
    }
}

