/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Action;

public class ActionDomAdapter
extends XmlAdapter {
    private static HashMap NODE_TYPES = null;

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("genericElement", "genericElement");
        }
        return NODE_TYPES;
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        Action action = (Action)jpdlElement;
        action.setConfigInfo(this.getTextContent());
        action.setClassName(this.getAttribute("class"));
        action.setConfigType(this.getAttribute("config-type"));
        action.setName(this.getAttribute("name"));
        action.setRefName(this.getAttribute("ref-name"));
        action.setAcceptPropagatedEvents(this.getAttribute("accept-propagated-events"));
        action.setExpression(this.getAttribute("expression"));
        action.setAsync(this.getAttribute("async"));
        action.addPropertyChangeListener(this);
    }

    protected void initialize() {
        super.initialize();
        Action action = (Action)this.getSemanticElement();
        if (action != null) {
            GenericElement[] genericElements = action.getGenericElements();
            int i = 0;
            while (i < genericElements.length) {
                this.addElement(genericElements[i]);
                ++i;
            }
            this.setTextContent(action.getConfigInfo());
            this.setAttribute("class", action.getClassName());
            this.setAttribute("config-type", action.getConfigType());
            this.setAttribute("name", action.getName());
            this.setAttribute("ref-name", action.getRefName());
            this.setAttribute("accept-propagated-events", action.getAcceptPropagatedEvents());
            this.setAttribute("expression", action.getExpression());
            this.setAttribute("async", action.getAsync());
        }
    }

    protected String getDefaultValue(String attributeName) {
        if ("accept-propagated-events".equals(attributeName)) {
            return "true";
        }
        if ("async".equals(attributeName)) {
            return "false";
        }
        if ("config-type".equals(attributeName)) {
            return "field";
        }
        return super.getDefaultValue(attributeName);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("configInfo".equals(evt.getPropertyName())) {
            this.setTextContent((String)evt.getNewValue());
        } else if ("className".equals(evt.getPropertyName())) {
            this.setAttribute("class", (String)evt.getNewValue());
        } else if ("configType".equals(evt.getPropertyName())) {
            this.setAttribute("config-type", (String)evt.getNewValue());
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        } else if ("refName".equals(evt.getPropertyName())) {
            this.setAttribute("ref-name", (String)evt.getNewValue());
        } else if ("acceptPropagatedEvents".equals(evt.getPropertyName())) {
            this.setAttribute("accept-propagated-events", (String)evt.getNewValue());
        } else if ("expression".equals(evt.getPropertyName())) {
            this.setAttribute("expression", (String)evt.getNewValue());
        } else if ("async".equals(evt.getPropertyName())) {
            this.setAttribute("async", (String)evt.getNewValue());
        } else if ("genericElementAdd".equals(evt.getPropertyName())) {
            this.addElement((SemanticElement)evt.getNewValue());
        } else if ("genericElementRemove".equals(evt.getPropertyName())) {
            this.removeElement((SemanticElement)evt.getOldValue());
        }
    }

    private boolean isDifferent(String left, String right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    protected void doModelUpdate(String name, String newValue) {
        Action action = (Action)this.getSemanticElement();
        if ("#text".equals(name) && action.getGenericElements().length == 0) {
            if (this.isDifferent(action.getConfigInfo(), this.getTextContent())) {
                action.setConfigInfo(newValue);
            }
        } else if ("class".equals(name)) {
            action.setClassName(newValue);
        } else if ("config-type".equals(name)) {
            action.setConfigType(newValue);
        } else if ("name".equals(name)) {
            action.setName(newValue);
        } else if ("ref-name".equals(name)) {
            action.setRefName(newValue);
        } else if ("accept-propagated-events".equals(name)) {
            action.setAcceptPropagatedEvents(newValue);
        } else if ("expression".equals(name)) {
            action.setExpression(newValue);
        } else if ("async".equals(name)) {
            action.setAsync(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = "genericElement".equals(type) ? this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.genericElement") : this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        Action action = (Action)this.getSemanticElement();
        if ("genericElement".equals(type)) {
            action.addGenericElement((GenericElement)jpdlElement);
        }
    }

    protected SemanticElement createSemanticElementFor(XmlAdapter child) {
        if ("genericElement".equals(child.getElementType())) {
            return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.genericElement");
        }
        return super.createSemanticElementFor(child);
    }

    protected void doModelRemove(XmlAdapter child) {
    }
}

