/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Assignment;

public class AssignmentDomAdapter
extends XmlAdapter {
    private static HashMap NODE_TYPES = null;

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("genericElement", "genericElement");
        }
        return NODE_TYPES;
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        Assignment assignment = (Assignment)jpdlElement;
        assignment.setConfigInfo(this.getTextContent());
        assignment.setClassName(this.getAttribute("class"));
        assignment.setConfigType(this.getAttribute("config-type"));
        assignment.setExpression(this.getAttribute("expression"));
        assignment.setActorId(this.getAttribute("actor-id"));
        assignment.setPooledActors(this.getAttribute("pooled-actors"));
        assignment.addPropertyChangeListener(this);
    }

    protected void initialize() {
        super.initialize();
        Assignment assignment = (Assignment)this.getSemanticElement();
        if (assignment != null) {
            GenericElement[] genericElements = assignment.getGenericElements();
            int i = 0;
            while (i < genericElements.length) {
                this.addElement(genericElements[i]);
                ++i;
            }
            this.setTextContent(assignment.getConfigInfo());
            this.setAttribute("class", assignment.getClassName());
            this.setAttribute("config-type", assignment.getConfigType());
            this.setAttribute("expression", assignment.getExpression());
            this.setAttribute("actor-id", assignment.getActorId());
            this.setAttribute("pooled-actors", assignment.getPooledActors());
        }
    }

    protected String getDefaultValue(String attributeName) {
        if ("config-type".equals(attributeName)) {
            return "field";
        }
        return super.getDefaultValue(attributeName);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("configInfo".equals(evt.getPropertyName())) {
            this.setTextContent((String)evt.getNewValue());
        } else if ("className".equals(evt.getPropertyName())) {
            this.setAttribute("class", (String)evt.getNewValue());
        } else if ("configType".equals(evt.getPropertyName())) {
            this.setAttribute("config-type", (String)evt.getNewValue());
        } else if ("expression".equals(evt.getPropertyName())) {
            this.setAttribute("expression", (String)evt.getNewValue());
        } else if ("actorId".equals(evt.getPropertyName())) {
            this.setAttribute("actor-id", (String)evt.getNewValue());
        } else if ("pooledActors".equals(evt.getPropertyName())) {
            this.setAttribute("pooled-actors", (String)evt.getNewValue());
        } else if ("genericElementAdd".equals(evt.getPropertyName())) {
            this.addElement((SemanticElement)evt.getNewValue());
        } else if ("genericElementRemove".equals(evt.getPropertyName())) {
            this.removeElement((SemanticElement)evt.getOldValue());
        }
    }

    private boolean isDifferent(String left, String right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    protected void doModelUpdate(String name, String newValue) {
        Assignment assignment = (Assignment)this.getSemanticElement();
        if ("#text".equals(name) && assignment.getGenericElements().length == 0) {
            if (this.isDifferent(assignment.getConfigInfo(), this.getTextContent())) {
                assignment.setConfigInfo(newValue);
            }
        } else if ("class".equals(name)) {
            assignment.setClassName(newValue);
        } else if ("config-type".equals(name)) {
            assignment.setConfigType(newValue);
        } else if ("expression".equals(name)) {
            assignment.setExpression(newValue);
        } else if ("actor-id".equals(name)) {
            assignment.setActorId(newValue);
        } else if ("pooled-actors".equals(name)) {
            assignment.setPooledActors(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        Assignment assignment = (Assignment)this.getSemanticElement();
        if ("genericElement".equals(type)) {
            assignment.addGenericElement((GenericElement)jpdlElement);
        }
    }

    protected SemanticElement createSemanticElementFor(XmlAdapter child) {
        if ("genericElement".equals(child.getElementType())) {
            return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.genericElement");
        }
        return super.createSemanticElementFor(child);
    }

    protected void doModelRemove(XmlAdapter child) {
    }
}

