/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.Handler;
import org.jbpm.gd.jpdl.model.Transition;

public class DecisionDomAdapter
extends XmlAdapter {
    private static final String[] CHILD_ELEMENTS = new String[]{"description", "handler", "event", "exception-handler", "transition"};
    private static HashMap NODE_TYPES = null;

    protected String[] getChildElements() {
        return CHILD_ELEMENTS;
    }

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("description", "description");
            NODE_TYPES.put("handler", "handler");
            NODE_TYPES.put("event", "event");
            NODE_TYPES.put("exception-handler", "exception-handler");
            NODE_TYPES.put("transition", "transition");
        }
        return NODE_TYPES;
    }

    protected String getDefaultValue(String attributeName) {
        if ("async".equals(attributeName)) {
            return "false";
        }
        return super.getDefaultValue(attributeName);
    }

    protected void initialize() {
        super.initialize();
        Decision decision = (Decision)this.getSemanticElement();
        if (decision != null) {
            this.setAttribute("name", decision.getName());
            this.setAttribute("async", decision.getAsync());
            this.setAttribute("expression", decision.getExpression());
            this.addElement(decision.getDescription());
            this.addElement(decision.getHandler());
            this.addElements(decision.getEvents());
            this.addElements(decision.getExceptionHandlers());
            this.addElements(decision.getTransitions());
        }
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        Decision decision = (Decision)jpdlElement;
        decision.setExpression(this.getAttribute("expression"));
        decision.setAsync(this.getAttribute("async"));
        decision.setName(this.getAttribute("name"));
        decision.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("handler".equals(evt.getPropertyName())) {
            this.setElement("handler", (Handler)evt.getOldValue(), (Handler)evt.getNewValue());
        } else if ("description".equals(evt.getPropertyName())) {
            this.setElement("description", (SemanticElement)evt.getOldValue(), (Description)evt.getNewValue());
        } else if ("handlerRemove".equals(evt.getPropertyName())) {
            this.removeElement((Handler)evt.getOldValue());
        } else if ("eventAdd".equals(evt.getPropertyName())) {
            this.addElement((Event)evt.getNewValue());
        } else if ("eventRemove".equals(evt.getPropertyName())) {
            this.removeElement((Event)evt.getOldValue());
        } else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
            this.addElement((ExceptionHandler)evt.getNewValue());
        } else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
            this.removeElement((ExceptionHandler)evt.getOldValue());
        } else if ("transitionAdd".equals(evt.getPropertyName())) {
            this.addElement((Transition)evt.getNewValue());
        } else if ("transitionRemove".equals(evt.getPropertyName())) {
            this.removeElement((Transition)evt.getOldValue());
        } else if ("expression".equals(evt.getPropertyName())) {
            this.setAttribute("expression", (String)evt.getNewValue());
        } else if ("async".equals(evt.getPropertyName())) {
            this.setAttribute("async", (String)evt.getNewValue());
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        Decision decision = (Decision)this.getSemanticElement();
        if ("name".equals(name)) {
            decision.setName(newValue);
        } else if ("async".equals(name)) {
            decision.setAsync(newValue);
        } else if ("expression".equals(name)) {
            decision.setExpression(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        Decision decision = (Decision)this.getSemanticElement();
        if ("handler".equals(type)) {
            decision.setHandler((Handler)jpdlElement);
        } else if ("description".equals(this.getNodeType(type))) {
            decision.setDescription((Description)jpdlElement);
        } else if ("event".equals(type)) {
            decision.addEvent((Event)jpdlElement);
        } else if ("exception-handler".equals(type)) {
            decision.addExceptionHandler((ExceptionHandler)jpdlElement);
        } else if ("transition".equals(type)) {
            decision.addTransition((Transition)jpdlElement);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        Decision decision = (Decision)this.getSemanticElement();
        if ("handler".equals(type)) {
            decision.setHandler(null);
        } else if ("description".equals(this.getNodeType(type))) {
            decision.setDescription(null);
        } else if ("event".equals(type)) {
            decision.removeEvent((Event)child.getSemanticElement());
        } else if ("exception-handler".equals(type)) {
            decision.removeExceptionHandler((ExceptionHandler)child.getSemanticElement());
        } else if ("transition".equals(type)) {
            decision.removeTransition((Transition)child.getSemanticElement());
        }
    }
}

