/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.MailAction;
import org.jbpm.gd.jpdl.model.Subject;
import org.jbpm.gd.jpdl.model.Text;

public class MailDomAdapter
extends XmlAdapter {
    private static final String[] CHILD_ELEMENTS = new String[]{"subject", "text"};
    private static HashMap NODE_TYPES = null;

    protected String[] getChildElements() {
        return CHILD_ELEMENTS;
    }

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("subject", "subject");
            NODE_TYPES.put("text", "text");
        }
        return NODE_TYPES;
    }

    protected String getDefaultValue(String attributeName) {
        if ("async".equals(attributeName)) {
            return "false";
        }
        return super.getDefaultValue(attributeName);
    }

    protected void initialize() {
        super.initialize();
        MailAction mail = (MailAction)this.getSemanticElement();
        if (mail != null) {
            this.setAttribute("async", mail.getAsync());
            this.setAttribute("template", mail.getTemplate());
            this.setAttribute("actors", mail.getActors());
            this.setAttribute("to", mail.getTo());
            this.setAttribute("name", mail.getName());
            this.addElement(mail.getSubject());
            this.addElement(mail.getText());
        }
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        MailAction mail = (MailAction)jpdlElement;
        mail.setAsync(this.getAttribute("async"));
        mail.setTemplate(this.getAttribute("template"));
        mail.setActors(this.getAttribute("actors"));
        mail.setTo(this.getAttribute("to"));
        mail.setName(this.getAttribute("name"));
        mail.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("subject".equals(evt.getPropertyName())) {
            this.setElement("subject", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("text".equals(evt.getPropertyName())) {
            this.setElement("text", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("async".equals(evt.getPropertyName())) {
            this.setAttribute("async", (String)evt.getNewValue());
        } else if ("template".equals(evt.getPropertyName())) {
            this.setAttribute("template", (String)evt.getNewValue());
        } else if ("actors".equals(evt.getPropertyName())) {
            this.setAttribute("actors", (String)evt.getNewValue());
        } else if ("to".equals(evt.getPropertyName())) {
            this.setAttribute("to", (String)evt.getNewValue());
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        MailAction mail = (MailAction)this.getSemanticElement();
        if ("async".equals(name)) {
            mail.setAsync(newValue);
        } else if ("template".equals(name)) {
            mail.setTemplate(newValue);
        } else if ("actors".equals(name)) {
            mail.setActors(newValue);
        } else if ("to".equals(name)) {
            mail.setTo(newValue);
        } else if ("name".equals(name)) {
            mail.setName(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        MailAction mail = (MailAction)this.getSemanticElement();
        if ("subject".equals(type)) {
            mail.setSubject((Subject)jpdlElement);
        } else if ("text".equals(type)) {
            mail.setText((Text)jpdlElement);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        MailAction mail = (MailAction)this.getSemanticElement();
        if ("subject".equals(type)) {
            mail.setSubject(null);
        } else if ("text".equals(type)) {
            mail.setText(null);
        } else if ("script".equals(type)) {
            mail.setText(null);
        }
    }
}

