/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.PersistenceDAO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionDTOPDAO
extends PersistenceDAO<NodeDefinitionDTO, Long>
implements NodeDefinitionDTODAI {
    public NodeDefinitionDTOPDAO(JPAPersistenceContext jPAPersistenceContext) {
        super(NodeDefinitionDTO.class, jPAPersistenceContext);
    }

    @Override
    public List<NodeDefinitionDTO> findAll() {
        String string = "NodeDefinitionDTO.All";
        Query query = this.getEntityManager().createNamedQuery(string);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findByResourceType(long l) {
        String string = "NodeDefinitionDTO.ByResourceType";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("resourceTypeId", (Object)l);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findSingleNodeDefinitionsByResourceType(long l) {
        String string = "NodeDefinitionDTO.SingleNodeDefinitionsByResourceType";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("resourceTypeId", (Object)l);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findByParentUsage(long l) {
        String string = "NodeDefinitionDTO.ByParentUsage";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("nodeDefinitionId", (Object)l);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public List<NodeDefinitionDTO> findSuperStateNodeDefinitionsByMessages(Set<Message> set) {
        if (set == null || set.isEmpty()) {
            return new ArrayList<NodeDefinitionDTO>();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT nd.id, message.id ");
        stringBuilder.append(this.getFromClause()).append(" nd, ");
        stringBuilder.append("IN (nd.messages) message ");
        stringBuilder.append("WHERE nd.id in (");
        boolean bl = true;
        for (Message message : set) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" and nd.id in (");
            }
            stringBuilder.append("SELECT nd.id ");
            stringBuilder.append(this.getFromClause()).append(" nd, ");
            stringBuilder.append("IN (nd.messages) message ");
            stringBuilder.append("WHERE nd.type = 1 AND message.id = ").append(message.getId());
        }
        int n = 1;
        while (n < set.size()) {
            stringBuilder.append(")");
            ++n;
        }
        stringBuilder.append(")");
        Query query = this.getEntityManager().createQuery(stringBuilder.toString());
        Map<Long, Set<Long>> map = this.buildNodeDefMessageMapping(query.getResultList());
        ArrayList<NodeDefinitionDTO> arrayList = new ArrayList<NodeDefinitionDTO>();
        for (Map.Entry entry : map.entrySet()) {
            Long l = (Long)entry.getKey();
            Set set2 = (Set)entry.getValue();
            if (!this.isSameSetOfMessages(set2, set)) continue;
            NodeDefinitionDTO nodeDefinitionDTO = new NodeDefinitionDTO();
            nodeDefinitionDTO.setId(l);
            arrayList.add(nodeDefinitionDTO);
        }
        return arrayList;
    }

    @Override
    public List<NodeDefinitionDTO> findSingleNodeDefinitionsByMessage(long l) {
        String string = "NodeDefinitionDTO.SingleNodeDefinitionsByMessage";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("id", (Object)l);
        return this.buildNodeDefinitions(query.getResultList());
    }

    @Override
    public int getCountByParentUsage(long l) {
        String string = "NodeDefinitionDTO.CountByParentUsage";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("nodeDefinitionId", (Object)l);
        Long l2 = (Long)query.getSingleResult();
        return l2.intValue();
    }

    @Override
    public int getCountByResourceType(long l) {
        String string = "NodeDefinitionDTO.CountByResourceType";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("resourceTypeId", (Object)l);
        Long l2 = (Long)query.getSingleResult();
        return l2.intValue();
    }

    @Override
    public int getCountByMessage(long l) {
        String string = "NodeDefinitionDTO.CountByMessage";
        Query query = this.getEntityManager().createNamedQuery(string);
        query.setParameter("messageId", (Object)l);
        Long l2 = (Long)query.getSingleResult();
        return l2.intValue();
    }

    @Override
    public List<NodeDefinitionDTO> findByKeys(Collection<Long> collection) {
        Long l2;
        if (collection == null || collection.size() == 0) {
            return new ArrayList<NodeDefinitionDTO>();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT nd.id, nd.name ");
        stringBuilder.append(this.getFromClause()).append(" nd ");
        stringBuilder.append("WHERE nd.id IN ( ");
        boolean bl = true;
        for (Long l2 : collection) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(l2.toString());
        }
        stringBuilder.append(" ) ");
        l2 = this.getEntityManager().createQuery(stringBuilder.toString());
        return this.buildNodeDefinitions(l2.getResultList());
    }

    @Override
    public int getCountByName(String string) {
        String string2 = "NodeDefinitionDTO.CountByName";
        Query query = this.getEntityManager().createNamedQuery(string2);
        query.setParameter("name", (Object)string);
        Long l = (Long)query.getSingleResult();
        return l.intValue();
    }

    @Override
    public void deleteNodeDefinitionReferences(long l) {
        String string = "DELETE TB_NODEDEFINITIONPARENTMAP WHERE NODEDEFINITIONID= :nodeDefinitionId";
        Query query = this.getEntityManager().createNativeQuery(string);
        query.setParameter("nodeDefinitionId", (Object)l);
        query.executeUpdate();
    }

    private List<NodeDefinitionDTO> buildNodeDefinitions(List<?> list) {
        ArrayList<NodeDefinitionDTO> arrayList = new ArrayList<NodeDefinitionDTO>();
        if (list != null) {
            for (Object obj : list) {
                Object[] objectArray = (Object[])obj;
                NodeDefinitionDTO nodeDefinitionDTO = new NodeDefinitionDTO();
                nodeDefinitionDTO.setResourceType(new ResourceType());
                int n = 0;
                while (n < objectArray.length) {
                    switch (n) {
                        case 0: {
                            nodeDefinitionDTO.setId((Long)objectArray[0]);
                            break;
                        }
                        case 1: {
                            nodeDefinitionDTO.setName((String)objectArray[1]);
                            break;
                        }
                        case 2: {
                            nodeDefinitionDTO.setType((NodeDefinitionType)objectArray[2]);
                            break;
                        }
                        case 3: {
                            nodeDefinitionDTO.getResourceType().setId((Long)objectArray[3]);
                            break;
                        }
                        case 4: {
                            nodeDefinitionDTO.getResourceType().setName((String)objectArray[4]);
                            break;
                        }
                        case 5: {
                            nodeDefinitionDTO.getResourceType().setOutOfTheBox((Boolean)objectArray[5]);
                            break;
                        }
                        case 6: {
                            nodeDefinitionDTO.setLock((ILock)objectArray[6]);
                        }
                    }
                    ++n;
                }
                arrayList.add(nodeDefinitionDTO);
            }
        }
        return arrayList;
    }

    private Map<Long, Set<Long>> buildNodeDefMessageMapping(List<?> list) {
        HashMap<Long, Set<Long>> hashMap = new HashMap<Long, Set<Long>>();
        if (list != null) {
            for (Object obj : list) {
                Object[] objectArray = (Object[])obj;
                Long l = (Long)objectArray[0];
                Long l2 = (Long)objectArray[1];
                HashSet<Long> hashSet = (HashSet<Long>)hashMap.get(l);
                if (hashSet == null) {
                    hashSet = new HashSet<Long>();
                    hashMap.put(l, hashSet);
                }
                hashSet.add(l2);
            }
        }
        return hashMap;
    }

    private boolean isSameSetOfMessages(Set<Long> set, Set<Message> set2) {
        if (set.size() == set2.size()) {
            for (Message message : set2) {
                if (set.contains(message.getId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

