/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service;

import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceValidationException
extends ServiceException {
    private static final long serialVersionUID = 7045667273830246578L;
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

    public ServiceValidationException() {
        super(ServiceErrorCode.GENERAL_VALIDATION_ERROR);
    }

    public ServiceValidationException(List<ValidationMessage> list) {
        this();
        this.setValidationMessages(list);
    }

    public ServiceValidationException(String string, List<ValidationMessage> list) {
        super(ServiceErrorCode.GENERAL_VALIDATION_ERROR, string);
        this.setValidationMessages(list);
    }

    public ServiceValidationException(String string, List<ValidationMessage> list, Throwable throwable) {
        super(ServiceErrorCode.GENERAL_VALIDATION_ERROR, string, throwable);
        this.setValidationMessages(list);
    }

    public List<ValidationMessage> getValidationMessages() {
        return this.messages;
    }

    void setValidationMessages(List<ValidationMessage> list) {
        this.messages.clear();
        if (list != null) {
            this.messages.addAll(list);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(" Validation Errors: ");
        for (ValidationMessage validationMessage : this.messages) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\t").append(validationMessage.getCode());
            stringBuilder.append(": ").append(validationMessage.getElement().toString());
        }
        return stringBuilder.toString();
    }
}

