/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.ConnectionTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;
import com.tandbergtv.watchpoint.studio.service.IMessageUIDGenerator;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeService
extends ServiceImpl
implements IResourceTypeService {
    private static final int MAX_UIDGEN_RETRY_COUNT = 100;

    @Override
    public List<ResourceType> getResourceTypeList() {
        Class[] classArray = new Class[]{};
        return (List)this.performOperation(classArray, new Object[0]);
    }

    @Override
    public List<ResourceType> getViewableResourceTypeList() {
        Class[] classArray = new Class[]{};
        return (List)this.performOperation(classArray, new Object[0]);
    }

    @Override
    public List<ResourceType> getViewableNonOOBResourceTypeList() {
        ArrayList<ResourceType> arrayList = new ArrayList<ResourceType>();
        List<ResourceType> list = this.getViewableResourceTypeList();
        if (list != null) {
            for (ResourceType resourceType : list) {
                if (resourceType.isOutOfTheBox()) continue;
                arrayList.add(resourceType);
            }
        }
        return arrayList;
    }

    @Override
    public ResourceType getResourceType(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (ResourceType)this.performOperation(classArray, l);
    }

    @Override
    public ResourceType getResourceTypeByName(String string) {
        Class[] classArray = new Class[]{String.class};
        return (ResourceType)this.performOperation(classArray, string);
    }

    @Override
    public ResourceType getResourceTypeBySystemId(String string) {
        Class[] classArray = new Class[]{String.class};
        return (ResourceType)this.performOperation(classArray, string);
    }

    @Override
    public ResourceType createResourceType(ResourceType resourceType) {
        Class[] classArray = new Class[]{ResourceType.class};
        return (ResourceType)this.performOperation(classArray, resourceType);
    }

    @Override
    public ResourceType updateResourceType(ResourceType resourceType) {
        Class[] classArray = new Class[]{ResourceType.class};
        return (ResourceType)this.performOperation(classArray, resourceType);
    }

    @Override
    public void deleteResourceType(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        this.performOperation(classArray, l);
    }

    @Override
    public ResourceType exportResourceType(long l, Map<String, Object> map) throws ExportFailureException {
        Class[] classArray = new Class[]{Long.TYPE};
        ResourceType resourceType = (ResourceType)this.performOperation(classArray, l);
        WatchPointDTOExporterFactory watchPointDTOExporterFactory = WatchPointDTOExporterFactory.createFactory();
        IWatchPointDTOExporter<ResourceType> iWatchPointDTOExporter = watchPointDTOExporterFactory.getExporter(ResourceType.class);
        iWatchPointDTOExporter.export(resourceType, map);
        return resourceType;
    }

    @Override
    public List<ValidationMessage> validateResourceType(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (List)this.performOperation(classArray, l);
    }

    @Override
    public boolean isResourceTypeNameUnique(String string) {
        Class[] classArray = new Class[]{String.class};
        return (Boolean)this.performOperation(classArray, string);
    }

    @Override
    public boolean isResourceTypeSystemIdUnique(String string) {
        Class[] classArray = new Class[]{String.class};
        return (Boolean)this.performOperation(classArray, string);
    }

    @Override
    public boolean isMessageNameUnique(long l, String string) {
        Class[] classArray = new Class[]{Long.TYPE, String.class};
        return (Boolean)this.performOperation(classArray, l, string);
    }

    @Override
    public List<Message> getResourceTypeMessages(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (List)this.performOperation(classArray, l);
    }

    @Override
    public List<Message> getUnusedResourceTypeMessages(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (List)this.performOperation(classArray, l);
    }

    @Override
    public List<Message> getUnusedResourceTypeMessages(long l, long l2) {
        Class[] classArray = new Class[]{Long.TYPE, Long.TYPE};
        return (List)this.performOperation(classArray, l, l2);
    }

    @Override
    public Message findMessageByUID(String string) {
        Class[] classArray = new Class[]{String.class};
        return (Message)this.performOperation(classArray, string);
    }

    @Override
    public List<ConnectionType> getAllConnectionTypes() {
        Class[] classArray = new Class[]{};
        return (List)this.performOperation(classArray, new Object[0]);
    }

    @Override
    public Message createMessage(Message message) {
        Class[] classArray = new Class[]{Message.class};
        return (Message)this.performOperation(classArray, message);
    }

    @Override
    public void deleteMessage(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        this.performOperation(classArray, l);
    }

    protected List<ResourceType> getResourceTypeList(IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.findAll();
    }

    protected List<ResourceType> getViewableResourceTypeList(IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.findAllViewable();
    }

    protected ResourceType getResourceType(long l, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return this.lockResourceType(l, resourceTypeDAI);
    }

    protected ResourceType getResourceTypeByName(String string, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.findByName(string);
    }

    protected ResourceType getResourceTypeBySystemId(String string, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.findBySystemId(string);
    }

    protected ResourceType createResourceType(ResourceType resourceType, IPersistenceContext iPersistenceContext) {
        String string;
        resourceType.setId(-1L);
        resourceType.setVersion(1);
        resourceType.setDirty(true);
        resourceType.setMessageSequenceNumber(1);
        resourceType.setMessages(new HashSet<Message>());
        String string2 = resourceType.getName();
        if (string2 != null) {
            resourceType.setName(string2.trim());
        }
        if ((string = resourceType.getSystemId()) != null) {
            resourceType.setSystemId(string.trim());
        }
        this.validateCreation(resourceType, iPersistenceContext);
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.create(resourceType);
    }

    protected ResourceType updateResourceType(ResourceType resourceType, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI;
        long l = resourceType.getId();
        ResourceType resourceType2 = this.lockResourceType(l, resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext));
        if (resourceType2.isOutOfTheBox()) {
            String string = "Modifying an out-of-the-box Resource Type is not allowed.";
            throw new ServiceException(ServiceErrorCode.RESOURCE_TYPE_CANNOT_UPDATE_OOBRESTYPE, string);
        }
        int n = resourceType2.getVersion();
        if (!resourceType2.isDirty()) {
            ++n;
        }
        resourceType.setVersion(n);
        resourceType.setDirty(true);
        resourceType.setMessageSequenceNumber(resourceType2.getMessageSequenceNumber());
        resourceType.setMessages(this.getMessagesForUpdate(resourceType, resourceType2));
        this.validateModification(resourceType, resourceType2, iPersistenceContext);
        MessageDAI messageDAI = this.createMessageDAO(iPersistenceContext);
        for (Message message : resourceType.getMessages()) {
            messageDAI.update(message);
        }
        return resourceTypeDAI.update(resourceType);
    }

    protected void deleteResourceType(long l, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        MessageDAI messageDAI = this.createMessageDAO(iPersistenceContext);
        ResourceType resourceType = this.lockResourceType(l, resourceTypeDAI);
        this.validateDeletion(resourceType, iPersistenceContext);
        Set<Message> set = resourceType.getMessages();
        if (set != null) {
            for (Message message : set) {
                messageDAI.delete(message.getId());
            }
        }
        resourceTypeDAI.delete(l);
    }

    protected ResourceType exportResourceType(long l, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        ResourceType resourceType = this.lockResourceType(l, resourceTypeDAI);
        this.validateExport(resourceType);
        if (!resourceType.isDirty()) {
            resourceType.setVersion(resourceType.getVersion() + 1);
        }
        resourceType.setDirty(false);
        resourceType = resourceTypeDAI.update(resourceType);
        return resourceType;
    }

    protected List<ValidationMessage> validateResourceType(long l, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        ResourceType resourceType = this.lockResourceType(l, resourceTypeDAI);
        return this.validateResourceType(resourceType);
    }

    protected boolean isResourceTypeNameUnique(String string, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.getCountByName(string) == 0;
    }

    protected boolean isResourceTypeSystemIdUnique(String string, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.getCountBySystemId(string) == 0;
    }

    protected boolean isMessageNameUnique(long l, String string, IPersistenceContext iPersistenceContext) {
        MessageDAI messageDAI = this.createMessageDAO(iPersistenceContext);
        return messageDAI.getCountByResourceTypeAndName(l, string) == 0;
    }

    protected List<Message> getResourceTypeMessages(long l, IPersistenceContext iPersistenceContext) {
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        return resourceTypeDAI.getMessagesById(l);
    }

    protected List<Message> getUnusedResourceTypeMessages(long l, IPersistenceContext iPersistenceContext) {
        return this.createMessageDAO(iPersistenceContext).findUnusedByResourceType(l);
    }

    protected List<Message> getUnusedResourceTypeMessages(long l, long l2, IPersistenceContext iPersistenceContext) {
        return this.createMessageDAO(iPersistenceContext).findUnusedByResourceType(l, l2);
    }

    protected Message findMessageByUID(String string, IPersistenceContext iPersistenceContext) {
        return this.createMessageDAO(iPersistenceContext).findByUID(string);
    }

    protected List<ConnectionType> getAllConnectionTypes(IPersistenceContext iPersistenceContext) {
        ConnectionTypeDAI connectionTypeDAI = this.createConnectionTypeDAO(iPersistenceContext);
        return connectionTypeDAI.findAll();
    }

    protected Message createMessage(Message message, IPersistenceContext iPersistenceContext) {
        String string;
        String string2;
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        long l = message.getResourceType().getId();
        ResourceType resourceType = this.lockResourceType(l, resourceTypeDAI);
        if (resourceType.isOutOfTheBox()) {
            String string3 = "Cannot create a new Message for an out-of-the-box Resource Type.";
            throw new ServiceException(ServiceErrorCode.MESSAGE_CANNOT_CREATE_OOBRESTYPE, string3);
        }
        ResourceType resourceType2 = resourceType.clone();
        resourceType2.addMessage(message);
        boolean bl = message.isUIDGenerationRequired();
        if (bl) {
            this.generateMessageUID(resourceType2, message);
            int n = resourceType2.getMessageSequenceNumber();
            resourceType.setMessageSequenceNumber(n);
        }
        if ((string2 = message.getName()) != null) {
            message.setName(string2.trim());
        }
        if ((string = message.getUid()) != null) {
            message.setUid(string.trim());
        }
        this.validateMessageCreation(message, iPersistenceContext);
        int n = resourceType.getVersion();
        if (!resourceType.isDirty()) {
            ++n;
        }
        resourceType.setVersion(n);
        resourceType.setDirty(true);
        resourceTypeDAI.update(resourceType);
        MessageDAI messageDAI = this.createMessageDAO(iPersistenceContext);
        return messageDAI.create(message);
    }

    protected void deleteMessage(long l, IPersistenceContext iPersistenceContext) {
        MessageDAI messageDAI = this.createMessageDAO(iPersistenceContext);
        Message message = (Message)messageDAI.find(l);
        if (message == null) {
            return;
        }
        long l2 = message.getResourceType().getId();
        ResourceTypeDAI resourceTypeDAI = this.createResourceTypeDAO(iPersistenceContext);
        ResourceType resourceType = this.lockResourceType(l2, resourceTypeDAI);
        this.validateMessageDeletion(message, resourceType, iPersistenceContext);
        if (!resourceType.isDirty()) {
            resourceType.setVersion(resourceType.getVersion() + 1);
            resourceType.setDirty(true);
            resourceTypeDAI.update(resourceType);
        }
        messageDAI.delete(l);
    }

    private void validateCreation(ResourceType resourceType, IPersistenceContext iPersistenceContext) {
        Object object;
        Object object2;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        if (resourceType.isOutOfTheBox()) {
            object2 = ValidationMessageCode.RESOURCE_TYPE_CANNOT_CREATE_OOB;
            arrayList.add(new ValidationMessage(resourceType, ValidationMessageType.Error, (ValidationMessageCode)((Object)object2)));
        }
        this.validateUniqueResourceTypeName(resourceType, iPersistenceContext, arrayList);
        object2 = resourceType.getSystemId();
        if (!this.isResourceTypeSystemIdUnique((String)object2, iPersistenceContext)) {
            object = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_NOT_UNIQUE;
            arrayList.add(new ValidationMessage(resourceType, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if ((object = this.validateResourceType(resourceType)) != null) {
            arrayList.addAll((Collection<ValidationMessage>)object);
        }
        if (this.isInvalid(arrayList)) {
            String string = "The Resource Type failed validation during creation.";
            throw new ServiceValidationException(string, arrayList);
        }
    }

    private void validateModification(ResourceType resourceType, ResourceType resourceType2, IPersistenceContext iPersistenceContext) {
        Object object;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        if (!resourceType2.getName().equalsIgnoreCase(resourceType.getName())) {
            this.validateUniqueResourceTypeName(resourceType, iPersistenceContext, arrayList);
        }
        if (!resourceType2.getSystemId().equals(resourceType.getSystemId())) {
            object = ValidationMessageCode.RESOURCE_TYPE_SYSTEM_ID_CHANGED;
            arrayList.add(new ValidationMessage(resourceType, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if (resourceType.getMessages() != null) {
            object = new HashMap();
            for (Message object2 : resourceType2.getMessages()) {
                object.put(object2.getKey(), object2);
            }
            for (Message message : resourceType.getMessages()) {
                ValidationMessageCode validationMessageCode;
                Message message2 = (Message)object.get(message.getKey());
                if (message2 == null) continue;
                if (!message2.getUid().equals(message.getUid())) {
                    validationMessageCode = ValidationMessageCode.MESSAGE_UID_CHANGED;
                    arrayList.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
                }
                if (message2.isIncoming() == message.isIncoming()) continue;
                validationMessageCode = ValidationMessageCode.MESSAGE_DIRECTION_CHANGED;
                arrayList.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
            }
        }
        if ((object = this.validateResourceType(resourceType)) != null) {
            arrayList.addAll((Collection<ValidationMessage>)object);
        }
        if (this.isInvalid(arrayList)) {
            String string = "The Resource Type failed validation during modification.";
            throw new ServiceValidationException(string, arrayList);
        }
    }

    private void validateDeletion(ResourceType resourceType, IPersistenceContext iPersistenceContext) {
        if (resourceType.isOutOfTheBox()) {
            String string = "Cannot delete an out-of-the-box Resource Type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_OOB_ERROR, string);
        }
        if (resourceType.getVersion() > 1 || !resourceType.isDirty()) {
            String string = "The resource type has already been exported, cannot delete this resource type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_EXPORTED_ERROR, string);
        }
        long l = resourceType.getId();
        ResourceGroupDAI resourceGroupDAI = this.createResourceGroupDAO(iPersistenceContext);
        int n = resourceGroupDAI.getCountByResourceType(l);
        if (n > 0) {
            String string = "The resource type is being used by existing resource groups, cannot delete this resource type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_USED_BY_RESOURCE_GROUP_ERROR, string);
        }
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        int n2 = nodeDefinitionDTODAI.getCountByResourceType(l);
        if (n2 > 0) {
            String string = "The resource type is being used by existing node definitions, cannot delete this resource type.";
            throw new ServiceException(ServiceErrorCode.RT_DELETE_USED_BY_NODE_DEFN_ERROR, string);
        }
    }

    private void validateExport(ResourceType resourceType) {
        Set<Message> set;
        if (resourceType.getAdaptorType() != AdaptorType.NONE && ((set = resourceType.getMessages()) == null || set.isEmpty())) {
            ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
            arrayList.add(new ValidationMessage(resourceType, ValidationMessageType.Error, ValidationMessageCode.RESOURCE_TYPE_CANNOT_EXPORT_NO_MESSAGES));
            String string = "The resource type has adaptor defined, but does not have messages. Cannot export this resource type.";
            throw new ServiceValidationException(string, arrayList);
        }
    }

    private List<ValidationMessage> validateResourceType(ResourceType resourceType) {
        ValidationServiceFactory validationServiceFactory = ValidationServiceFactory.createFactory();
        IValidationService iValidationService = validationServiceFactory.createValidationService();
        return iValidationService.validateResourceType(resourceType);
    }

    private void validateUniqueResourceTypeName(ResourceType resourceType, IPersistenceContext iPersistenceContext, List<ValidationMessage> list) {
        String string = resourceType.getName();
        if (!this.isResourceTypeNameUnique(string, iPersistenceContext)) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_NAME_NOT_UNIQUE;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private boolean isInvalid(List<ValidationMessage> list) {
        boolean bl = false;
        if (list != null) {
            for (ValidationMessage validationMessage : list) {
                if (validationMessage.getType() != ValidationMessageType.Error && validationMessage.getType() != ValidationMessageType.Warning) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void validateMessageCreation(Message message, IPersistenceContext iPersistenceContext) {
        Object object;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        long l = message.getResourceType().getId();
        AdaptorType adaptorType = message.getResourceType().getAdaptorType();
        String string = message.getName();
        if (adaptorType == null || adaptorType == AdaptorType.NONE) {
            object = ValidationMessageCode.RESOURCE_TYPE_ADAPTOR_TYPE_INVALID;
            arrayList.add(new ValidationMessage(message, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if (!this.isMessageNameUnique(l, string, iPersistenceContext)) {
            object = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_NOT_UNIQUE;
            arrayList.add(new ValidationMessage(message, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if (!this.isMessageUidUnique(message, iPersistenceContext)) {
            object = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_UID_NOT_UNIQUE;
            arrayList.add(new ValidationMessage(message, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if ((object = this.validateMessage(message)) != null) {
            arrayList.addAll((Collection<ValidationMessage>)object);
        }
        if (this.isInvalid(arrayList)) {
            String string2 = "The Message failed validation during creation.";
            throw new ServiceValidationException(string2, arrayList);
        }
    }

    private void validateMessageDeletion(Message message, ResourceType resourceType, IPersistenceContext iPersistenceContext) {
        if (resourceType.isOutOfTheBox()) {
            String string = "Cannot delete a Message that belongs to an out-of-the-box Resource Type.";
            throw new ServiceException(ServiceErrorCode.RT_MESSAGE_DELETE_OOBRESTYPE_ERROR, string);
        }
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        int n = nodeDefinitionDTODAI.getCountByMessage(message.getId());
        if (n > 0) {
            String string = "The message is being used by existing node definitions, cannot delete this message.";
            throw new ServiceException(ServiceErrorCode.RT_MESSAGE_DELETE_USED_BY_NODE_DEFN_ERROR, string);
        }
    }

    private List<ValidationMessage> validateMessage(Message message) {
        ValidationServiceFactory validationServiceFactory = ValidationServiceFactory.createFactory();
        IValidationService iValidationService = validationServiceFactory.createValidationService();
        return iValidationService.validateMessage(message);
    }

    private boolean isMessageUidUnique(Message message, IPersistenceContext iPersistenceContext) {
        MessageDAI messageDAI = this.createMessageDAO(iPersistenceContext);
        return messageDAI.getCountByUID(message.getUid()) == 0;
    }

    private ResourceType lockResourceType(long l, ResourceTypeDAI resourceTypeDAI) {
        ResourceType resourceType = (ResourceType)resourceTypeDAI.lock(l);
        if (resourceType == null) {
            String string = "The Resource Type has already been deleted, cannot perform operation on this Resource Type.";
            throw new ServiceException(ServiceErrorCode.WT_OPERATION_ON_DELETED_TEMPLATE, string);
        }
        return resourceType;
    }

    private ResourceTypeDAI createResourceTypeDAO(IPersistenceContext iPersistenceContext) {
        Class<ResourceType> clazz = ResourceType.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ResourceTypeDAI)dataAccessInterface;
    }

    private ResourceGroupDAI createResourceGroupDAO(IPersistenceContext iPersistenceContext) {
        Class<ResourceGroup> clazz = ResourceGroup.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ResourceGroupDAI)dataAccessInterface;
    }

    private NodeDefinitionDTODAI createNodeDefinitionDAO(IPersistenceContext iPersistenceContext) {
        Class<NodeDefinitionDTO> clazz = NodeDefinitionDTO.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (NodeDefinitionDTODAI)dataAccessInterface;
    }

    private ConnectionTypeDAI createConnectionTypeDAO(IPersistenceContext iPersistenceContext) {
        Class<ConnectionType> clazz = ConnectionType.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ConnectionTypeDAI)dataAccessInterface;
    }

    private MessageDAI createMessageDAO(IPersistenceContext iPersistenceContext) {
        Class<Message> clazz = Message.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (MessageDAI)dataAccessInterface;
    }

    private Set<Message> getMessagesForUpdate(ResourceType resourceType, ResourceType resourceType2) {
        HashSet<Message> hashSet = new HashSet<Message>();
        Set<Message> set = resourceType.getMessages();
        Set<Message> set2 = resourceType2.getMessages();
        if (set == null || set2 == null) {
            return hashSet;
        }
        for (Message message : set) {
            if (!set2.contains(message)) continue;
            hashSet.add(message);
        }
        return hashSet;
    }

    private void generateMessageUID(ResourceType resourceType, Message message) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        for (Message object2 : resourceType.getMessages()) {
            if (object2.isUIDGenerationRequired()) continue;
            hashSet.add(object2.getUid());
        }
        ServiceFactory serviceFactory = ServiceFactory.createFactory();
        IMessageUIDGenerator iMessageUIDGenerator = serviceFactory.createMessageUIDGenerator();
        int n = resourceType.getMessageSequenceNumber();
        int n2 = 0;
        while (message.isUIDGenerationRequired() && n2 < 100) {
            string = iMessageUIDGenerator.generateMessageUID(message, resourceType);
            resourceType.setMessageSequenceNumber(++n);
            ++n2;
            if (hashSet.contains(string)) continue;
            message.setUid(string);
            message.setUIDGenerationRequired(false);
        }
        if (message.isUIDGenerationRequired()) {
            string = "Failed to generate a Message UID for the resource type.";
            throw new ServiceException(ServiceErrorCode.RT_UID_GENERATION_ERROR, string);
        }
    }
}

