/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessFactory;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.PersistenceContextFactory;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.service.IService;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceImpl
implements IService {
    private static final Logger logger = Logger.getLogger(ServiceImpl.class);
    private static final String PERSISTENCE_OPERATION_NAME = "performOperation";
    protected PersistenceContextFactory pcFactory;
    protected DataAccessFactory daFactory = DataAccessFactory.createFactory();

    protected ServiceImpl() {
        this.pcFactory = PersistenceContextFactory.createFactory();
    }

    protected IPersistenceContext createPersistenceContext() {
        IPersistenceContext iPersistenceContext = this.pcFactory.createPersistenceContext();
        iPersistenceContext.initialize();
        return iPersistenceContext;
    }

    protected DataAccessInterface<? extends IPersistable, ? extends Serializable> createDAO(IPersistable iPersistable, IPersistenceContext iPersistenceContext) {
        return this.daFactory.createDataAccessObject(iPersistable, iPersistenceContext);
    }

    protected void closePersistenceContext(IPersistenceContext iPersistenceContext) {
        try {
            iPersistenceContext.close();
        }
        catch (Exception exception) {
            String string = "Failed to close the Persistence Context: " + exception.getLocalizedMessage();
            logger.error((Object)string, (Throwable)exception);
        }
    }

    protected void beginTransaction(IPersistenceContext iPersistenceContext) {
        iPersistenceContext.beginTransaction();
    }

    protected void commitTransaction(IPersistenceContext iPersistenceContext) {
        iPersistenceContext.commitTransaction();
    }

    protected void rollbackTransaction(IPersistenceContext iPersistenceContext) {
        try {
            iPersistenceContext.rollbackTransaction();
        }
        catch (Exception exception) {
            String string = "Failed when rolling back the current transaction: " + exception.getLocalizedMessage();
            logger.error((Object)string, (Throwable)exception);
        }
    }

    protected Object performOperation(Class<?>[] classArray, Object ... objectArray) {
        Method method = this.findMethodToInvoke(classArray, objectArray);
        int n = objectArray != null ? objectArray.length : 0;
        Object[] objectArray2 = new Object[n + 1];
        int n2 = 0;
        while (n2 < n) {
            objectArray2[n2] = objectArray[n2];
            ++n2;
        }
        IPersistenceContext iPersistenceContext = this.createPersistenceContext();
        objectArray2[n] = iPersistenceContext;
        try {
            this.beginTransaction(iPersistenceContext);
            Object object = method.invoke((Object)this, objectArray2);
            this.commitTransaction(iPersistenceContext);
            Object object2 = object;
            return object2;
        }
        catch (Exception exception) {
            String string = String.valueOf(this.getClass().getName()) + "." + method.getName() + "().";
            String string2 = "Failed to perform operation: " + string;
            logger.error((Object)string2, (Throwable)exception);
            this.rollbackTransaction(iPersistenceContext);
            throw this.generateException(method.getName(), exception);
        }
        finally {
            this.closePersistenceContext(iPersistenceContext);
        }
    }

    private Method findMethodToInvoke(Class<?>[] classArray, Object ... objectArray) {
        String string = null;
        try {
            String string2 = ServiceImpl.class.getName();
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            int n = -1;
            int n2 = 0;
            while (n2 < stackTraceElementArray.length) {
                String string3 = stackTraceElementArray[n2].getClassName();
                String string4 = stackTraceElementArray[n2].getMethodName();
                if (string2.equals(string3) && PERSISTENCE_OPERATION_NAME.equals(string4)) {
                    n = n2 + 1;
                    break;
                }
                ++n2;
            }
            string = stackTraceElementArray[n].getMethodName();
            ArrayList arrayList = new ArrayList();
            int n3 = classArray != null ? classArray.length : 0;
            int n4 = 0;
            while (n4 < n3) {
                arrayList.add(classArray[n4]);
                ++n4;
            }
            arrayList.add(IPersistenceContext.class);
            return this.getClass().getDeclaredMethod(string, arrayList.toArray(new Class[0]));
        }
        catch (Exception exception) {
            String string5 = "Failed to find method: " + string + " in class: " + this.getClass().getName() + " to invoke.";
            logger.error((Object)string5, (Throwable)exception);
            throw new StudioRuntimeException(string5, exception);
        }
    }

    private RuntimeException generateException(String string, Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        String string2 = "Failed to perform operation: " + this.getClass().getName() + "." + string + "().";
        return new ServiceException(ServiceErrorCode.GENERAL_ERROR, string2, throwable);
    }
}

