/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;
import com.tandbergtv.watchpoint.studio.lock.ILock;
import com.tandbergtv.watchpoint.studio.lock.ILockOperationResult;
import com.tandbergtv.watchpoint.studio.lock.ILockStrategy;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.lock.LockAttributes;
import com.tandbergtv.watchpoint.studio.lock.LockFactory;
import com.tandbergtv.watchpoint.studio.service.IWorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTemplateService
extends ServiceImpl
implements IWorkflowTemplateService {
    private static final Logger logger = Logger.getLogger(WorkflowTemplateService.class);
    private static final String PROCESS_DEFINITION_XPATH = "/process-definition";
    private static final String VERSION_ATTR_NAME = "version";
    private static final String NODE_DEFINITION_ID_XPATH = "//nodeDefinition/@id";
    private static final String RESOURCEGROUP_NAME_XPATH = "//resource-group/@name";
    private static final String PROTECTION_KEY_XPATH = "//protection-key/@name";

    @Override
    public List<WorkflowTemplateDTO> getTemplateList() {
        Class[] classArray = new Class[]{};
        return (List)super.performOperation(classArray, new Object[0]);
    }

    @Override
    public WorkflowTemplateDTO createTemplate(WorkflowTemplateDTO workflowTemplateDTO, String string, boolean bl) {
        Class[] classArray = new Class[]{WorkflowTemplateDTO.class, String.class, Boolean.TYPE};
        return (WorkflowTemplateDTO)super.performOperation(classArray, workflowTemplateDTO, string, bl);
    }

    @Override
    public WorkflowTemplateDTO getTemplateForView(String string) {
        Class[] classArray = new Class[]{String.class};
        return (WorkflowTemplateDTO)super.performOperation(classArray, string);
    }

    @Override
    public WorkflowTemplateDTO getTemplateForEdit(String string, String string2, boolean bl) {
        Class[] classArray = new Class[]{String.class, String.class, Boolean.TYPE};
        return (WorkflowTemplateDTO)super.performOperation(classArray, string, string2, bl);
    }

    @Override
    public WorkflowTemplateDTO saveTemplate(WorkflowTemplateDTO workflowTemplateDTO, String string) {
        Class[] classArray = new Class[]{WorkflowTemplateDTO.class, String.class};
        return (WorkflowTemplateDTO)super.performOperation(classArray, workflowTemplateDTO, string);
    }

    @Override
    public void closeTemplate(long l, String string) {
        Class[] classArray = new Class[]{Long.TYPE, String.class};
        super.performOperation(classArray, l, string);
    }

    @Override
    public void deleteTemplate(String string, String string2) {
        Class[] classArray = new Class[]{String.class, String.class};
        super.performOperation(classArray, string, string2);
    }

    @Override
    public WorkflowTemplateDTO exportTemplate(String string, Map<String, Object> map) throws ExportFailureException {
        WorkflowTemplateDTO workflowTemplateDTO = null;
        Class[] classArray = new Class[]{String.class};
        workflowTemplateDTO = (WorkflowTemplateDTO)super.performOperation(classArray, string);
        WatchPointDTOExporterFactory watchPointDTOExporterFactory = WatchPointDTOExporterFactory.createFactory();
        IWatchPointDTOExporter<WorkflowTemplateDTO> iWatchPointDTOExporter = watchPointDTOExporterFactory.getExporter(WorkflowTemplateDTO.class);
        iWatchPointDTOExporter.export(workflowTemplateDTO, map);
        return workflowTemplateDTO;
    }

    @Override
    public WorkflowTemplateDTO publishTemplate(String string, String string2) {
        Class[] classArray = new Class[]{String.class, String.class};
        return (WorkflowTemplateDTO)super.performOperation(classArray, string, string2);
    }

    @Override
    public WorkflowTemplateDTO unpublishTemplate(String string) {
        Class[] classArray = new Class[]{String.class};
        return (WorkflowTemplateDTO)super.performOperation(classArray, string);
    }

    @Override
    public List<ValidationMessage> validateTemplateForPublish(String string) {
        Class[] classArray = new Class[]{String.class};
        return (List)super.performOperation(classArray, string);
    }

    @Override
    public boolean nameExists(String string) {
        Class[] classArray = new Class[]{String.class};
        return (Boolean)super.performOperation(classArray, string);
    }

    protected List<WorkflowTemplateDTO> getTemplateList(IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        return workflowTemplateDTODAI.findByCurrentVersion();
    }

    protected WorkflowTemplateDTO createTemplate(WorkflowTemplateDTO workflowTemplateDTO, String string, boolean bl, IPersistenceContext iPersistenceContext) {
        workflowTemplateDTO.setId(-1L);
        workflowTemplateDTO.setDirty(true);
        workflowTemplateDTO.setExportable(false);
        workflowTemplateDTO.setActive(true);
        Document document = this.loadTemplateDocument(workflowTemplateDTO);
        this.setTemplateVersion(workflowTemplateDTO, document, 1);
        String string2 = workflowTemplateDTO.getName();
        if (string2 != null) {
            workflowTemplateDTO.setName(string2.trim());
        }
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        this.updateNodeDefinitionsUsed(workflowTemplateDTO, document, nodeDefinitionDTODAI);
        this.updateProtectionKeysUsed(workflowTemplateDTO, document, iPersistenceContext);
        ResourceGroupDAI resourceGroupDAI = this.createResourceGroupDAO(iPersistenceContext);
        this.updateResourceGroupsUsed(workflowTemplateDTO, document, resourceGroupDAI);
        ILock iLock = bl ? LockFactory.createFactory().createLock(string) : null;
        workflowTemplateDTO.setLock(iLock);
        this.validateNewTemplate(workflowTemplateDTO, iPersistenceContext);
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        return workflowTemplateDTODAI.create(workflowTemplateDTO);
    }

    protected WorkflowTemplateDTO getTemplateForView(String string, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        return this.lockTemplate(string, workflowTemplateDTODAI);
    }

    protected WorkflowTemplateDTO getTemplateForEdit(String string, String string2, boolean bl, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        WorkflowTemplateDTO workflowTemplateDTO = this.lockTemplate(string, workflowTemplateDTODAI);
        if (workflowTemplateDTO.isExportable()) {
            String string3 = "The template is currently published, cannot edit this template.";
            throw new ServiceException(ServiceErrorCode.WT_EDIT_PUBLISHED_ERROR, string3);
        }
        ILockStrategy iLockStrategy = LockFactory.createFactory().createLockStrategy();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put(LockAttributes.OVERRIDE_LOCK.toString(), Boolean.valueOf(bl));
        ILockOperationResult iLockOperationResult = iLockStrategy.tryLock(string2, workflowTemplateDTO, hashMap, iPersistenceContext);
        if (!iLockOperationResult.getOperationResult()) {
            String string4 = "Failed to acquire a lock for the template, cannot edit this template.";
            ILockable iLockable = iLockOperationResult.getLockableEntity();
            throw new LockFailureException(ServiceErrorCode.WT_EDIT_LOCK_ERROR, iLockable, string4);
        }
        return (WorkflowTemplateDTO)iLockOperationResult.getLockableEntity();
    }

    protected WorkflowTemplateDTO saveTemplate(WorkflowTemplateDTO workflowTemplateDTO, String string, IPersistenceContext iPersistenceContext) {
        boolean bl;
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        WorkflowTemplateDTO workflowTemplateDTO2 = (WorkflowTemplateDTO)workflowTemplateDTODAI.lock(workflowTemplateDTO.getId());
        if (!workflowTemplateDTO2.isActive()) {
            String string2 = "The Template has already been deleted, cannot save this template.";
            throw new ServiceException(ServiceErrorCode.WT_OPERATION_ON_DELETED_TEMPLATE, string2);
        }
        ILock iLock = workflowTemplateDTO2.getLock();
        if (iLock == null || !iLock.getOwnerId().equals(string)) {
            String string3 = "The template is not currently locked for the user, cannot save this template.";
            throw new ServiceException(ServiceErrorCode.WT_SAVE_UNLOCKED_ERROR, string3);
        }
        workflowTemplateDTO.setDirty(true);
        workflowTemplateDTO.setActive(workflowTemplateDTO2.isActive());
        workflowTemplateDTO.setExportable(workflowTemplateDTO2.isExportable());
        workflowTemplateDTO.setLock(workflowTemplateDTO2.getLock());
        Document document = this.loadTemplateDocument(workflowTemplateDTO);
        NodeDefinitionDTODAI nodeDefinitionDTODAI = this.createNodeDefinitionDAO(iPersistenceContext);
        this.updateNodeDefinitionsUsed(workflowTemplateDTO, document, nodeDefinitionDTODAI);
        this.updateProtectionKeysUsed(workflowTemplateDTO, document, iPersistenceContext);
        ResourceGroupDAI resourceGroupDAI = this.createResourceGroupDAO(iPersistenceContext);
        this.updateResourceGroupsUsed(workflowTemplateDTO, document, resourceGroupDAI);
        this.validateExistingTemplate(workflowTemplateDTO, workflowTemplateDTO2, iPersistenceContext);
        boolean bl2 = bl = !workflowTemplateDTO2.isDirty();
        if (bl) {
            String string4 = workflowTemplateDTO2.getName();
            int n = this.generateNewVersionNumber(string4, workflowTemplateDTODAI);
            this.setTemplateVersion(workflowTemplateDTO, document, n);
            workflowTemplateDTO.setId(-1L);
            workflowTemplateDTO2.setLock(null);
            workflowTemplateDTODAI.update(workflowTemplateDTO2);
            workflowTemplateDTO.setLock(LockFactory.createFactory().createLock(string));
            workflowTemplateDTO = workflowTemplateDTODAI.create(workflowTemplateDTO);
        } else {
            this.setTemplateVersion(workflowTemplateDTO, document, workflowTemplateDTO2.getVersion());
            workflowTemplateDTO = workflowTemplateDTODAI.update(workflowTemplateDTO);
        }
        return workflowTemplateDTO;
    }

    protected void closeTemplate(long l, String string, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTO workflowTemplateDTO = new WorkflowTemplateDTO();
        workflowTemplateDTO.setId(l);
        ILockStrategy iLockStrategy = LockFactory.createFactory().createLockStrategy();
        iLockStrategy.releaseLock(string, workflowTemplateDTO, iPersistenceContext);
    }

    protected void deleteTemplate(String string, String string2, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        DataAccessInterface dataAccessInterface = null;
        WorkflowTemplateDTO workflowTemplateDTO = this.lockTemplate(string, workflowTemplateDTODAI);
        if (workflowTemplateDTO.isExportable()) {
            String string3 = "The template is currently published, cannot delete this template.";
            throw new ServiceException(ServiceErrorCode.WT_DELETE_PUBLISHED_ERROR, string3);
        }
        ILock iLock = workflowTemplateDTO.getLock();
        if (iLock != null && !iLock.getOwnerId().equals(string2)) {
            String string4 = "The template is locked by another user, cannot delete this template.";
            throw new ServiceException(ServiceErrorCode.WT_DELETE_LOCKED_ERROR, string4);
        }
        if (iLock != null) {
            workflowTemplateDTO.setLock(null);
            workflowTemplateDTODAI.update(workflowTemplateDTO);
            dataAccessInterface = this.daFactory.createDataAccessObject(iLock, iPersistenceContext);
            dataAccessInterface.delete(iLock.getKey());
        }
        int n = workflowTemplateDTODAI.setInactiveByName(string);
        logger.debug((Object)("The number of deleted templates: " + n));
        workflowTemplateDTODAI.deleteResourceGroupMap(string);
    }

    protected WorkflowTemplateDTO exportTemplate(String string, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        WorkflowTemplateDTO workflowTemplateDTO = this.lockTemplate(string, workflowTemplateDTODAI);
        if (!workflowTemplateDTO.isExportable()) {
            String string2 = "The template has not been published, cannot export this template.";
            throw new ServiceException(ServiceErrorCode.WT_EXPORT_UNPUBLISHED_ERROR, string2);
        }
        workflowTemplateDTO.setDirty(false);
        workflowTemplateDTODAI.update(workflowTemplateDTO);
        return workflowTemplateDTO;
    }

    protected WorkflowTemplateDTO publishTemplate(String string, String string2, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        WorkflowTemplateDTO workflowTemplateDTO = this.lockTemplate(string, workflowTemplateDTODAI);
        if (workflowTemplateDTO.getLock() != null && !workflowTemplateDTO.getLock().getOwnerId().equals(string2)) {
            String string3 = "The template is currently locked by a different user, cannot publish the template.";
            throw new ServiceException(ServiceErrorCode.WT_PUBLISHED_LOCKED_ERROR, string3);
        }
        if (!workflowTemplateDTO.isExportable()) {
            this.validateExportableTemplate(workflowTemplateDTO);
            workflowTemplateDTO.setExportable(true);
            workflowTemplateDTO.setLock(null);
            workflowTemplateDTODAI.update(workflowTemplateDTO);
        }
        return workflowTemplateDTO;
    }

    protected WorkflowTemplateDTO unpublishTemplate(String string, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        WorkflowTemplateDTO workflowTemplateDTO = this.lockTemplate(string, workflowTemplateDTODAI);
        if (workflowTemplateDTO.isExportable()) {
            workflowTemplateDTO.setExportable(false);
            workflowTemplateDTODAI.update(workflowTemplateDTO);
        }
        return workflowTemplateDTO;
    }

    protected List<ValidationMessage> validateTemplateForPublish(String string, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        WorkflowTemplateDTO workflowTemplateDTO = this.lockTemplate(string, workflowTemplateDTODAI);
        return this.validateTemplate(workflowTemplateDTO);
    }

    protected boolean nameExists(String string, IPersistenceContext iPersistenceContext) {
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        return workflowTemplateDTODAI.getCountByName(string) > 0;
    }

    private WorkflowTemplateDTODAI createTemplateDAO(IPersistenceContext iPersistenceContext) {
        Class<WorkflowTemplateDTO> clazz = WorkflowTemplateDTO.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (WorkflowTemplateDTODAI)dataAccessInterface;
    }

    private NodeDefinitionDTODAI createNodeDefinitionDAO(IPersistenceContext iPersistenceContext) {
        Class<NodeDefinitionDTO> clazz = NodeDefinitionDTO.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (NodeDefinitionDTODAI)dataAccessInterface;
    }

    private ResourceGroupDAI createResourceGroupDAO(IPersistenceContext iPersistenceContext) {
        Class<ResourceGroup> clazz = ResourceGroup.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ResourceGroupDAI)dataAccessInterface;
    }

    private ProtectionKeyDAI createProtectionKeyDAO(IPersistenceContext iPersistenceContext) {
        Class<ProtectionKey> clazz = ProtectionKey.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ProtectionKeyDAI)dataAccessInterface;
    }

    private int generateNewVersionNumber(String string, WorkflowTemplateDTODAI workflowTemplateDTODAI) {
        Long l = workflowTemplateDTODAI.getTemplateIdByNameForOldestVersion(string);
        workflowTemplateDTODAI.lock(l);
        int n = workflowTemplateDTODAI.getCurrentVersionNumberByName(string) + 1;
        return n;
    }

    private void updateNodeDefinitionsUsed(WorkflowTemplateDTO workflowTemplateDTO, Document document, NodeDefinitionDTODAI nodeDefinitionDTODAI) {
        Object object;
        HashSet<NodeDefinitionDTO> hashSet = new HashSet<NodeDefinitionDTO>();
        workflowTemplateDTO.setNodeDefinitions(hashSet);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        try {
            object = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)object.evaluate(NODE_DEFINITION_ID_XPATH, document, XPathConstants.NODESET);
            int n = nodeList != null ? nodeList.getLength() : 0;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                String string = node.getNodeValue();
                if (string != null && string.trim().length() > 0) {
                    hashSet2.add(Long.parseLong(string));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String string = "Failed to get the list of Node Definition Ids specified in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_NODE_DEFN_UPDATE_ERROR, string, exception);
        }
        object = nodeDefinitionDTODAI.findByKeys(hashSet2);
        if (object != null) {
            hashSet.addAll((Collection<NodeDefinitionDTO>)object);
        }
    }

    private void updateResourceGroupsUsed(WorkflowTemplateDTO workflowTemplateDTO, Document document, ResourceGroupDAI resourceGroupDAI) {
        HashSet<String> hashSet = new HashSet<String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate(RESOURCEGROUP_NAME_XPATH, document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = "Failed to get the list of Resource Group Names specified in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_RESGRP_UPDATE_ERROR, string, xPathExpressionException);
        }
        int n = nodeList != null ? nodeList.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string = node.getNodeValue();
            if (string != null && string.trim().length() > 0) {
                hashSet.add(string);
            }
            ++n2;
        }
        HashSet<ResourceGroup> hashSet2 = new HashSet<ResourceGroup>();
        hashSet2.addAll(resourceGroupDAI.findByNames(hashSet));
        workflowTemplateDTO.setResourceGroups(hashSet2);
    }

    private void updateProtectionKeysUsed(WorkflowTemplateDTO workflowTemplateDTO, Document document, IPersistenceContext iPersistenceContext) {
        Object object;
        ArrayList arrayList;
        Object object2;
        HashSet<ProtectionKey> hashSet = new HashSet<ProtectionKey>();
        workflowTemplateDTO.setProtectionKeys(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        try {
            object2 = XPathFactory.newInstance().newXPath();
            arrayList = (NodeList)object2.evaluate(PROTECTION_KEY_XPATH, document, XPathConstants.NODESET);
            int n = arrayList != null ? arrayList.getLength() : 0;
            int n2 = 0;
            while (n2 < n) {
                Node node = arrayList.item(n2);
                object = node.getNodeValue();
                if (object != null && ((String)object).trim().length() > 0) {
                    hashSet2.add(((String)object).trim());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String string = "Failed to get the set of Protection Keys specified in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_PROTECTION_KEY_UPDATE_ERROR, string, exception);
        }
        object2 = this.createProtectionKeyDAO(iPersistenceContext);
        arrayList = object2.findByNames(hashSet2);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        HashSet<String> hashSet3 = new HashSet<String>(hashSet2);
        for (ProtectionKey protectionKey : arrayList) {
            hashSet3.remove(protectionKey.getName());
        }
        hashSet.addAll(arrayList);
        for (String string : hashSet3) {
            object = new ProtectionKey();
            ((ProtectionKey)object).setName(string);
            hashSet.add((ProtectionKey)object2.create(object));
        }
    }

    private void setTemplateVersion(WorkflowTemplateDTO workflowTemplateDTO, Document document, int n) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Element element = (Element)xPath.evaluate(PROCESS_DEFINITION_XPATH, document, XPathConstants.NODE);
            element.setAttribute(VERSION_ATTR_NAME, Integer.toString(n));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            workflowTemplateDTO.setXml(stringWriter.toString());
            workflowTemplateDTO.setVersion(n);
        }
        catch (Exception exception) {
            String string = "Failed to update the version attribute in the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_VERSION_UPDATE_ERROR, string, exception);
        }
    }

    private WorkflowTemplateDTO lockTemplate(String string, WorkflowTemplateDTODAI workflowTemplateDTODAI) {
        Long l = workflowTemplateDTODAI.getTemplateIdByName(string);
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)workflowTemplateDTODAI.lock(l);
        if (!workflowTemplateDTO.isActive()) {
            String string2 = "The Template has already been deleted, cannot perform operation on this template.";
            throw new ServiceException(ServiceErrorCode.WT_OPERATION_ON_DELETED_TEMPLATE, string2);
        }
        return workflowTemplateDTO;
    }

    private Document loadTemplateDocument(WorkflowTemplateDTO workflowTemplateDTO) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            StringReader stringReader = new StringReader(workflowTemplateDTO.getXml());
            return documentBuilderFactory.newDocumentBuilder().parse(new InputSource(stringReader));
        }
        catch (Exception exception) {
            String string = "Failed to load the Workflow Template XML.";
            throw new ServiceException(ServiceErrorCode.WT_INVALID_XML, string, exception);
        }
    }

    private void validateNewTemplate(WorkflowTemplateDTO workflowTemplateDTO, IPersistenceContext iPersistenceContext) {
        Object object;
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createTemplateDAO(iPersistenceContext);
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        String string = workflowTemplateDTO.getName();
        if (string == null || string.length() == 0) {
            object = ValidationMessageCode.TEMPLATE_NAME_BLANK;
            arrayList.add(new ValidationMessage(workflowTemplateDTO, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        } else {
            int n = workflowTemplateDTODAI.getCountByName(workflowTemplateDTO.getName());
            if (n > 0) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.TEMPLATE_NAME_NOT_UNIQUE;
                arrayList.add(new ValidationMessage(workflowTemplateDTO, ValidationMessageType.Error, validationMessageCode));
            }
        }
        if (arrayList.size() > 0) {
            object = "The Template failed validation during creation.";
            throw new ServiceValidationException((String)object, arrayList);
        }
    }

    private void validateExistingTemplate(WorkflowTemplateDTO workflowTemplateDTO, WorkflowTemplateDTO workflowTemplateDTO2, IPersistenceContext iPersistenceContext) {
        Object object;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        String string = workflowTemplateDTO2.getName();
        if (!string.equals(workflowTemplateDTO.getName())) {
            object = ValidationMessageCode.TEMPLATE_NAME_CHANGED;
            arrayList.add(new ValidationMessage(workflowTemplateDTO, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
        }
        if (arrayList.size() > 0) {
            object = "The Template failed validation when updating.";
            throw new ServiceValidationException((String)object, arrayList);
        }
    }

    private void validateExportableTemplate(WorkflowTemplateDTO workflowTemplateDTO) {
        List<ValidationMessage> list = this.validateTemplate(workflowTemplateDTO);
        if (list != null) {
            boolean bl = false;
            for (ValidationMessage object : list) {
                if (object.getType() != ValidationMessageType.Error && object.getType() != ValidationMessageType.Warning) continue;
                bl = true;
                break;
            }
            if (bl) {
                String string = "The Template failed validation when attempting to publish the template.";
                throw new ServiceValidationException(string, list);
            }
        }
    }

    private List<ValidationMessage> validateTemplate(WorkflowTemplateDTO workflowTemplateDTO) {
        ValidationServiceFactory validationServiceFactory = ValidationServiceFactory.createFactory();
        IValidationService iValidationService = validationServiceFactory.createValidationService();
        return iValidationService.validateTemplate(workflowTemplateDTO);
    }
}

