/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.jbpm.gd.common.notation.RootContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionActionRegistry
extends ActionRegistry {
    private NodeDefinitionEditor editorPart;
    private List<String> editPartActionIds;
    private List<String> stackActionIds;
    private List<String> editorActionIds;

    public NodeDefinitionActionRegistry(NodeDefinitionEditor nodeDefinitionEditor) {
        this.initEditorPart(nodeDefinitionEditor);
        this.initActionLists();
        this.initActions();
    }

    private void initEditorPart(NodeDefinitionEditor nodeDefinitionEditor) {
        this.editorPart = nodeDefinitionEditor;
    }

    private void initActionLists() {
        this.editPartActionIds = new ArrayList<String>();
        this.stackActionIds = new ArrayList<String>();
        this.editorActionIds = new ArrayList<String>();
    }

    private void initActions() {
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this.editorPart));
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this.editorPart));
        this.addDeleteAction();
        this.addEditPartAction((WorkbenchPartAction)new SaveAction((IEditorPart)this.editorPart));
        this.registerAction((IAction)new PrintAction((IWorkbenchPart)this.editorPart));
    }

    private void addDeleteAction() {
        RootContainer rootContainer = this.editorPart.getRootContainer();
        NodeDefinition nodeDefinition = (NodeDefinition)rootContainer.getSemanticElement();
        NodeDefinitionType nodeDefinitionType = nodeDefinition.getNodeType();
        if (nodeDefinitionType != NodeDefinitionType.SingleNode) {
            this.addEditPartAction((WorkbenchPartAction)new DeleteAction((IWorkbenchPart)this.editorPart));
        }
    }

    private void addEditPartAction(WorkbenchPartAction workbenchPartAction) {
        this.registerAction((IAction)workbenchPartAction);
        this.editPartActionIds.add(workbenchPartAction.getId());
    }

    private void addStackAction(StackAction stackAction) {
        this.registerAction((IAction)stackAction);
        this.stackActionIds.add(stackAction.getId());
    }

    private void updateActions(List<String> list) {
        for (String string : list) {
            IAction iAction = this.getAction(string);
            if (iAction == null || !(iAction instanceof UpdateAction)) continue;
            ((UpdateAction)iAction).update();
        }
    }

    public void updateStackActions() {
        this.updateActions(this.stackActionIds);
    }

    public void updateEditPartActions() {
        this.updateActions(this.editPartActionIds);
    }

    public void updateEditorActions() {
        this.updateActions(this.editorActionIds);
    }
}

