/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.service.IWorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.GraphicalEditPartFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.WPContentProvider;
import com.tandbergtv.watchpoint.studio.ui.editor.WPFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.template.TemplateExplorer;
import java.util.EventObject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.common.editor.GraphicalViewer;
import org.jbpm.gd.common.editor.OutlineViewer;
import org.jbpm.gd.common.editor.SelectionSynchronizer;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.editor.JpdlDeploymentEditorPage;
import org.jbpm.gd.jpdl.editor.JpdlSelectionSynchronizer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WatchPointTemplateEditor
extends Editor
implements IPartListener2 {
    private static final String PROCESSIMAGE_JPG = "processimage.jpg";
    WorkflowTemplateDTO templateDTO;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.templateDTO = (WorkflowTemplateDTO)((WPFileEditorInput)iEditorInput).getWatchPointDTO();
        super.init(iEditorSite, iEditorInput);
        this.initPartName();
        Utility.setWindow(iEditorSite.getWorkbenchWindow());
        this.initCommandStackListener();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public boolean isDirty() {
        return this.isLockedByCurrentUser() && super.isDirty();
    }

    private void initPartName() {
        FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
        IPath iPath = fileEditorInput.getPath().removeLastSegments(1);
        iPath = iPath.removeFirstSegments(iPath.segmentCount() - 1);
        this.setPartName(iPath.lastSegment());
    }

    protected SelectionSynchronizer createSelectionSynchronizer() {
        return new JpdlSelectionSynchronizer();
    }

    protected ContentProvider createContentProvider() {
        return new WPContentProvider();
    }

    protected GraphicalViewer createGraphicalViewer() {
        return new GraphicalViewer(this){

            protected void initEditPartFactory() {
                this.setEditPartFactory(new GraphicalEditPartFactory());
            }
        };
    }

    protected OutlineViewer createOutlineViewer() {
        return null;
    }

    protected SemanticElement createMainElement() {
        return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.processDefinition");
    }

    public String getDefaultImageFileName() {
        return PROCESSIMAGE_JPG;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        Node node = this.getDocumentElement();
        WorkflowTemplateDTO workflowTemplateDTO = Utility.createTemplateDTO(this.templateDTO.getId(), this.templateDTO.getVersion(), this.getProcessDefinition().getName(), Utility.getXMLFromDocument(node.getOwnerDocument()), TemplateResourcesUtility.getTemplateGpdXml());
        try {
            IWorkflowTemplateService iWorkflowTemplateService = ServiceFactory.createFactory().createWorkflowTemplateService();
            this.templateDTO = this.templateDTO.getVersion() == 0 ? iWorkflowTemplateService.createTemplate(workflowTemplateDTO, Utility.getUserName(), true) : iWorkflowTemplateService.saveTemplate(workflowTemplateDTO, Utility.getUserName());
            this.getProcessDefinition().setVersion(this.templateDTO.getVersion());
        }
        catch (Exception exception) {
            this.setDirty(true);
            this.firePropertyChange(257);
            iProgressMonitor.setCanceled(true);
            if (exception instanceof ServiceValidationException) {
                ServiceValidationException serviceValidationException = (ServiceValidationException)exception;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid Template", (String)"The template is invalid, can not save.");
                Utility.updateValidationErrors(this.getSite(), serviceValidationException.getValidationMessages());
            }
            if (exception instanceof ServiceException) {
                throw new UIException(ServiceErrors.getInstance().getProperty(((ServiceException)exception).getServiceErrorCode().getCode()), exception);
            }
            throw new UIException(exception);
        }
    }

    public void dispose() {
        super.dispose();
        this.getEditorSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
    }

    public WorkflowTemplate getProcessDefinition() {
        return (WorkflowTemplate)this.getRootContainer().getSemanticElement();
    }

    public void setTemplateDTO(WorkflowTemplateDTO workflowTemplateDTO) {
        this.templateDTO = workflowTemplateDTO;
    }

    public WorkflowTemplateDTO getTemplateDTO() {
        return this.templateDTO;
    }

    public String getTemplateDTOName() {
        return this.templateDTO != null ? this.templateDTO.getName() : null;
    }

    public String getPartName() {
        if (this.getRootContainer() == null) {
            return super.getPartName();
        }
        return this.getProcessDefinition().getName();
    }

    public Node getDocumentElement() {
        StructuredTextEditor structuredTextEditor = this.getSourcePage();
        Element element = null;
        Document document = (Document)structuredTextEditor.getAdapter(Document.class);
        if (document != null) {
            element = document.getDocumentElement();
        }
        return element;
    }

    protected void createPages() {
        super.createPages();
        this.getEditorSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    protected void addPage(int n, IEditorPart iEditorPart, String string) {
        if (iEditorPart instanceof JpdlDeploymentEditorPage) {
            return;
        }
        super.addPage(n, iEditorPart, string);
    }

    protected void initSourcePage() {
        super.initSourcePage();
        WorkflowTemplate workflowTemplate = this.getProcessDefinition();
        NodeElement[] nodeElementArray = workflowTemplate.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            Transition[] transitionArray = nodeElement.getTransitions();
            int n3 = transitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                transition.setSource(nodeElement);
                ++n4;
            }
            ++n2;
        }
    }

    private StructuredTextEditor getSourcePage() {
        StructuredTextEditor structuredTextEditor = null;
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getEditor(n2) instanceof StructuredTextEditor) {
                structuredTextEditor = (StructuredTextEditor)this.getEditor(n2);
            }
            ++n2;
        }
        return structuredTextEditor;
    }

    private void initCommandStackListener() {
        CommandStackListener commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject eventObject) {
                WatchPointTemplateEditor.this.handleCommandStackChanged();
            }
        };
        this.getCommandStack().addCommandStackListener(commandStackListener);
    }

    private void handleCommandStackChanged() {
        this.handleTemplateChanged();
    }

    private void handleTemplateChanged() {
        if (this.templateDTO.getLock() == null || !this.templateDTO.getLock().getOwnerId().equals(Utility.getUserName())) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Template locked", (String)"This template is open in view mode, any changes you make will be lost.");
        }
    }

    private boolean isLockedByCurrentUser() {
        return this.templateDTO.getLock() != null && this.templateDTO.getLock().getOwnerId().equals(Utility.getUserName());
    }

    public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        IViewPart iViewPart;
        IWorkbenchPage iWorkbenchPage;
        if (iWorkbenchPartReference.getPart(false) != this) {
            return;
        }
        ServiceFactory serviceFactory = ServiceFactory.createFactory();
        IWorkflowTemplateService iWorkflowTemplateService = serviceFactory.createWorkflowTemplateService();
        if (this.templateDTO != null) {
            iWorkflowTemplateService.closeTemplate(this.templateDTO.getId(), Utility.getUserName());
        }
        if ((iWorkbenchPage = this.getSite().getPage()) != null && (iViewPart = iWorkbenchPage.findView("com.tandbergtv.gd.TemplateExplorer")) != null) {
            ((TemplateExplorer)iViewPart).refresh();
        }
    }

    public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }
}

