/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AdaptorTypeSectionPart
extends ResourceTypeSectionPart {
    Label typeLabel;
    CCombo typeCombo;
    private List<AdaptorType> adaptorTypes = new ArrayList<AdaptorType>();

    public AdaptorTypeSectionPart(IEditorPart iEditorPart, Composite composite, FormToolkit formToolkit, int n) {
        super(iEditorPart, composite, formToolkit, n);
    }

    public AdaptorType getAdaptorType() {
        int n = this.typeCombo.getSelectionIndex();
        AdaptorType adaptorType = AdaptorType.NONE;
        if (n != -1) {
            adaptorType = this.adaptorTypes.get(n);
        }
        return adaptorType;
    }

    public CCombo getTypeCombo() {
        return this.typeCombo;
    }

    public void commit(boolean bl) {
        super.commit(bl);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            int n = this.typeCombo.getSelectionIndex();
            AdaptorType adaptorType = AdaptorType.NONE;
            if (n != -1) {
                adaptorType = this.adaptorTypes.get(n);
            }
            resourceType.setAdaptorType(adaptorType);
        }
    }

    protected void createSectionClientControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.typeLabel = formToolkit.createLabel(this.sectionClient, "Adaptor Type: ");
        int n = formToolkit.getBorderStyle() | 8;
        this.typeCombo = new CCombo(this.sectionClient, n);
        formToolkit.adapt((Control)this.typeCombo, true, true);
        this.typeCombo.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
    }

    protected void initializeSectionClientLayout(IManagedForm iManagedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.typeLabel.setLayoutData((Object)this.createLabelGridData());
        this.typeCombo.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        int n;
        ResourceType resourceType = this.getResourceType();
        this.typeCombo.removeAll();
        this.adaptorTypes.clear();
        AdaptorType[] adaptorTypeArray = AdaptorType.values();
        int n2 = adaptorTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            AdaptorType adaptorType = adaptorTypeArray[n3];
            this.adaptorTypes.add(adaptorType);
            this.typeCombo.add(this.getAdaptorTypeDisplayName(adaptorType));
            ++n3;
        }
        n3 = n = this.adaptorTypes.indexOf(AdaptorType.NONE);
        if (resourceType != null && (n3 = this.adaptorTypes.indexOf(resourceType.getAdaptorType())) == -1) {
            n3 = n;
        }
        this.typeCombo.select(n3);
    }

    protected void setWidgetPermissions() {
        boolean bl = this.isInputEditable();
        this.typeCombo.setEnabled(bl);
    }

    private String getAdaptorTypeDisplayName(AdaptorType adaptorType) {
        String string = adaptorType.toString();
        switch (adaptorType) {
            case NONE: {
                string = "None";
                break;
            }
            case CUSTOM: {
                string = "Custom";
                break;
            }
            case DEFAULT: {
                string = "Default";
            }
        }
        return string;
    }
}

