/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.AdaptorScope;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ParametersCompositeContainer;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.Map;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CustomAdaptorSectionPart
extends ResourceTypeSectionPart {
    Label classNameLabel;
    Label parametersLabel;
    Text classNameText;
    Composite parametersComposite;
    ParametersCompositeContainer parametersContainer;

    public CustomAdaptorSectionPart(IEditorPart iEditorPart, Composite composite, FormToolkit formToolkit, int n) {
        super(iEditorPart, composite, formToolkit, n);
    }

    public void commit(boolean bl) {
        super.commit(bl);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            String string = this.classNameText.getText();
            resourceType.setAdaptorClassName(string);
            resourceType.setAdaptorScope(AdaptorScope.APPLICATION);
            Map<String, String> map = this.parametersContainer.getParameters();
            resourceType.setAdaptorParameters(map);
        }
    }

    protected void createSectionClientControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.classNameLabel = formToolkit.createLabel(this.sectionClient, "Adaptor Class: ");
        this.classNameText = formToolkit.createText(this.sectionClient, "");
        this.classNameText.setTextLimit(256);
        this.classNameText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.classNameText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.parametersLabel = formToolkit.createLabel(this.sectionClient, "Adaptor Parameters: ");
        this.parametersComposite = formToolkit.createComposite(this.sectionClient);
        formToolkit.paintBordersFor(this.parametersComposite);
        this.parametersContainer = new ParametersCompositeContainer(this.editorPart, (AbstractFormPart)this, formToolkit, this.parametersComposite);
    }

    protected void initializeSectionClientLayout(IManagedForm iManagedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(2, false));
        this.classNameLabel.setLayoutData((Object)this.createLabelGridData());
        this.parametersLabel.setLayoutData((Object)this.createLabelGridData());
        GridData gridData = this.createGridData();
        gridData.widthHint = this.getDefaultClassNameTextWidth();
        this.classNameText.setLayoutData((Object)gridData);
        this.parametersComposite.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        boolean bl = this.isInputEditable();
        if (resourceType != null) {
            String string = resourceType.getAdaptorClassName();
            this.classNameText.setText(this.formatValue(string, true));
            Map<String, String> map = resourceType.getAdaptorParameters();
            this.parametersContainer.setInput(map, bl);
        } else {
            this.classNameText.setText("");
            this.parametersContainer.setInput(null, bl);
        }
    }

    protected void setWidgetPermissions() {
        boolean bl = this.isInputEditable();
        this.classNameText.setEditable(bl);
    }
}

