/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ParametersCompositeContainer;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart;
import java.util.Map;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InitializationSectionPart
extends ResourceTypeSectionPart {
    protected Label classLabel;
    protected Label parametersLabel;
    protected Button requiredButton;
    protected Group configGroup;
    protected Text classText;
    protected Composite parametersComposite;
    protected ParametersCompositeContainer parametersContainer;

    public InitializationSectionPart(IEditorPart iEditorPart, Composite composite, FormToolkit formToolkit, int n) {
        super(iEditorPart, composite, formToolkit, n);
    }

    public void commit(boolean bl) {
        super.commit(bl);
        ResourceType resourceType = this.getResourceType();
        if (resourceType != null) {
            resourceType.setInitializationRequired(this.requiredButton.getSelection());
            resourceType.setInitializationStrategyClass(this.classText.getText());
            Map<String, String> map = this.parametersContainer.getParameters();
            resourceType.setInitializationParameters(map);
        }
    }

    protected void createSectionClientControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.requiredButton = formToolkit.createButton(this.sectionClient, "Requires Initialization", 16416);
        this.requiredButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.configGroup = new Group(this.sectionClient, 0);
        formToolkit.adapt((Composite)this.configGroup);
        formToolkit.paintBordersFor((Composite)this.configGroup);
        this.classLabel = formToolkit.createLabel((Composite)this.configGroup, "Initialization Strategy Class: ");
        this.classText = formToolkit.createText((Composite)this.configGroup, "");
        this.classText.setTextLimit(256);
        this.classText.addFocusListener((FocusListener)new TextTrimFocusListener());
        this.classText.addModifyListener((ModifyListener)new FormPartDirtyModifyListener((AbstractFormPart)this));
        this.parametersLabel = formToolkit.createLabel((Composite)this.configGroup, "Initialization Parameters: ");
        this.parametersComposite = formToolkit.createComposite((Composite)this.configGroup);
        formToolkit.paintBordersFor(this.parametersComposite);
        this.parametersContainer = new ParametersCompositeContainer(this.editorPart, (AbstractFormPart)this, formToolkit, this.parametersComposite);
    }

    protected void initializeSectionClientLayout(IManagedForm iManagedForm) {
        this.sectionClient.setLayout((Layout)this.createGridLayout(1, false));
        this.requiredButton.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayoutData((Object)this.createGridData());
        this.configGroup.setLayout((Layout)this.createGridLayout(2, false));
        this.classLabel.setLayoutData((Object)this.createLabelGridData());
        this.parametersLabel.setLayoutData((Object)this.createLabelGridData());
        GridData gridData = this.createGridData();
        gridData.widthHint = this.getDefaultClassNameTextWidth();
        this.classText.setLayoutData((Object)gridData);
        this.parametersComposite.setLayoutData((Object)this.createGridData());
    }

    protected void populateSectionData() {
        ResourceType resourceType = this.getResourceType();
        boolean bl = this.isInputEditable();
        if (resourceType != null) {
            this.requiredButton.setSelection(resourceType.isInitializationRequired());
            String string = resourceType.getInitializationStrategyClass();
            this.classText.setText(this.formatValue(string, true));
            Map<String, String> map = resourceType.getInitializationParameters();
            this.parametersContainer.setInput(map, bl);
        } else {
            this.requiredButton.setSelection(false);
            this.classText.setText("");
            this.parametersContainer.setInput(null, bl);
        }
    }

    protected void setWidgetPermissions() {
        boolean bl = this.isInputEditable();
        this.requiredButton.setEnabled(bl);
        this.classText.setEditable(bl);
        this.updateConfigControlAccess();
    }

    private void updateConfigControlAccess() {
        boolean bl = this.requiredButton.getSelection();
        this.configGroup.setEnabled(bl);
        this.classText.setEnabled(bl);
        this.parametersContainer.setEnabled(bl);
    }

    private void handleRequiredButtonSelected() {
        if (!this.isInputEditable()) {
            return;
        }
        this.updateConfigControlAccess();
        this.configGroup.redraw();
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            InitializationSectionPart.this.handleRequiredButtonSelected();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            InitializationSectionPart.this.handleRequiredButtonSelected();
            if (!InitializationSectionPart.this.isDirty()) {
                InitializationSectionPart.this.markDirty();
            }
        }
    }
}

