/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog.ResourceTypeParameterDialog;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog.ResourceTypeParameterNameValidator;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog.ResourceTypeParameterValueValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParametersCompositeContainer {
    AbstractFormPart formPart;
    Composite parametersComposite;
    Table parameterTable;
    TableColumn nameColumn;
    TableColumn valueColumn;
    Composite buttonComposite;
    Button addButton;
    Button removeButton;
    Button editButton;
    private Map<String, String> parameters;
    private boolean isEditable = true;
    private IEditorPart editorPart;

    public ParametersCompositeContainer(IEditorPart iEditorPart, AbstractFormPart abstractFormPart, FormToolkit formToolkit, Composite composite) {
        this.editorPart = iEditorPart;
        this.formPart = abstractFormPart;
        this.parametersComposite = composite;
        this.initialize(formToolkit, composite);
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.parameterTable.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = this.parameterTable.getItem(n2);
            String string = tableItem.getText(0);
            String string2 = tableItem.getText(1);
            hashMap.put(string, string2);
            ++n2;
        }
        return hashMap;
    }

    public void setEnabled(boolean bl) {
        this.parameterTable.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
        this.editButton.setEnabled(bl);
        if (bl) {
            this.setWidgetPermissions();
        }
    }

    private void initialize(FormToolkit formToolkit, Composite composite) {
        this.initializeTable(formToolkit, composite);
        this.buttonComposite = formToolkit.createComposite(composite);
        formToolkit.paintBordersFor(this.buttonComposite);
        this.addButton = formToolkit.createButton(this.buttonComposite, "Add...", 8);
        this.editButton = formToolkit.createButton(this.buttonComposite, "Edit...", 8);
        this.removeButton = formToolkit.createButton(this.buttonComposite, "Remove", 8);
        this.addButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.editButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.removeButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.initializeLayouts(composite);
        this.updateButtonStatus();
    }

    protected void initializeTable(FormToolkit formToolkit, Composite composite) {
        this.parameterTable = formToolkit.createTable(composite, 65540);
        this.nameColumn = new TableColumn(this.parameterTable, 16384, 0);
        this.nameColumn.setText("Parameter Name");
        this.nameColumn.setToolTipText("Parameter Name");
        this.nameColumn.setResizable(false);
        this.nameColumn.setMoveable(false);
        this.nameColumn.setWidth(130);
        this.valueColumn = new TableColumn(this.parameterTable, 16384, 1);
        this.valueColumn.setText("Parameter Value");
        this.valueColumn.setToolTipText("Parameter Value");
        this.valueColumn.setResizable(false);
        this.valueColumn.setMoveable(false);
        this.valueColumn.setWidth(200);
        this.parameterTable.setHeaderVisible(true);
        this.parameterTable.setSortColumn(this.nameColumn);
        this.parameterTable.setSortDirection(1024);
        this.parameterTable.setTopIndex(0);
        this.parameterTable.setLinesVisible(true);
        this.parameterTable.addSelectionListener((SelectionListener)new TableSelectionListener());
    }

    protected void initializeLayouts(Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.heightHint = 85;
        this.parameterTable.setLayoutData((Object)gridData);
        gridData = new GridData(1, 1, false, true);
        this.buttonComposite.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.pack = false;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 2;
        rowLayout.marginLeft = 2;
        rowLayout.spacing = 5;
        this.buttonComposite.setLayout((Layout)rowLayout);
        this.addButton.setLayoutData((Object)new RowData());
        this.editButton.setLayoutData((Object)new RowData());
        this.removeButton.setLayoutData((Object)new RowData());
    }

    public void setInput(Map<String, String> map, boolean bl) {
        this.parameters = map;
        this.isEditable = bl;
        this.populateData();
        this.setWidgetPermissions();
    }

    protected void populateData() {
        this.parameterTable.setRedraw(false);
        try {
            this.parameterTable.removeAll();
            if (this.parameters != null) {
                ArrayList arrayList = new ArrayList(this.parameters.keySet());
                Collections.sort(arrayList, new ParameterNameComparator());
                for (String string : arrayList) {
                    String string2 = this.parameters.get(string);
                    string = string != null ? string.trim() : "";
                    string2 = string2 != null ? string2 : "";
                    TableItem tableItem = new TableItem(this.parameterTable, 0);
                    tableItem.setText(new String[]{string, string2});
                }
            }
        }
        finally {
            this.parameterTable.setRedraw(true);
        }
    }

    protected void setWidgetPermissions() {
        this.addButton.setEnabled(this.isEditable);
        this.editButton.setEnabled(this.isEditable);
        this.removeButton.setEnabled(this.isEditable);
        this.updateButtonStatus();
    }

    protected void updateButtonStatus() {
        if (!this.isEditable) {
            return;
        }
        boolean bl = this.parameterTable.getSelectionIndex() != -1;
        this.editButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    protected void addParameter() {
        ResourceTypeParameterDialog resourceTypeParameterDialog = this.createParameterDialog(null, null);
        if (resourceTypeParameterDialog.open() == 0) {
            String string = resourceTypeParameterDialog.getParameterName();
            String string2 = resourceTypeParameterDialog.getParameterValue();
            this.insertParameterInTable(string, string2);
            this.markFormPartDirty();
        }
    }

    protected void editParameter() {
        String string;
        TableItem tableItem;
        String string2;
        ResourceTypeParameterDialog resourceTypeParameterDialog;
        int n = this.parameterTable.getSelectionIndex();
        if (n != -1 && (resourceTypeParameterDialog = this.createParameterDialog(string2 = (tableItem = this.parameterTable.getItem(n)).getText(0), string = tableItem.getText(1))).open() == 0) {
            String string3 = resourceTypeParameterDialog.getParameterName();
            String string4 = resourceTypeParameterDialog.getParameterValue();
            if (string2.equals(string3) && string.equals(string4)) {
                return;
            }
            if (string2.equals(string3)) {
                tableItem.setText(1, string4);
            } else {
                this.parameterTable.remove(n);
                this.insertParameterInTable(string3, string4);
            }
            this.markFormPartDirty();
        }
    }

    protected void removeParameter() {
        int n = this.parameterTable.getSelectionIndex();
        if (n != -1) {
            this.parameterTable.remove(n);
            int n2 = this.parameterTable.getItemCount();
            if (n >= n2) {
                n = n2 - 1;
            }
            this.parameterTable.select(n);
            this.updateButtonStatus();
            this.markFormPartDirty();
        }
    }

    private ResourceTypeParameterDialog createParameterDialog(String string, String string2) {
        ResourceTypeParameterDialog resourceTypeParameterDialog = null;
        Shell shell = this.parametersComposite.getShell();
        String string3 = this.editorPart.getSite().getPluginId();
        resourceTypeParameterDialog = new ResourceTypeParameterDialog(shell, string3, string, string2);
        Set<String> set = this.getParameterNames();
        resourceTypeParameterDialog.setParameterNameValidator(new ResourceTypeParameterNameValidator(set, string));
        resourceTypeParameterDialog.setParameterValueValidator(new ResourceTypeParameterValueValidator());
        return resourceTypeParameterDialog;
    }

    private Set<String> getParameterNames() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < this.parameterTable.getItemCount()) {
            hashSet.add(this.parameterTable.getItem(n).getText(0));
            ++n;
        }
        return hashSet;
    }

    private void insertParameterInTable(String string, String string2) {
        int n = this.parameterTable.getItemCount();
        int n2 = 0;
        while (n2 < this.parameterTable.getItemCount()) {
            String string3 = this.parameterTable.getItem(n2).getText(0);
            if (string3.compareToIgnoreCase(string) > 0 || string3.compareToIgnoreCase(string) == 0 && string3.compareTo(string) > 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        TableItem tableItem = new TableItem(this.parameterTable, 0, n);
        tableItem.setText(new String[]{string, string2});
        this.parameterTable.select(n);
        this.updateButtonStatus();
    }

    private void markFormPartDirty() {
        if (this.formPart != null && !this.formPart.isDirty()) {
            this.formPart.markDirty();
        }
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() == ParametersCompositeContainer.this.addButton) {
                ParametersCompositeContainer.this.addParameter();
            } else if (selectionEvent.getSource() == ParametersCompositeContainer.this.editButton) {
                ParametersCompositeContainer.this.editParameter();
            } else if (selectionEvent.getSource() == ParametersCompositeContainer.this.removeButton) {
                ParametersCompositeContainer.this.removeParameter();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterNameComparator
    implements Comparator<String> {
        private ParameterNameComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string.length();
            int n2 = string2.length();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n && n4 < n2) {
                char c;
                char c2 = string.charAt(n3);
                if (c2 != (c = string2.charAt(n4)) && (c2 = Character.toUpperCase(c2)) != (c = Character.toUpperCase(c)) && (c2 = Character.toLowerCase(c2)) != (c = Character.toLowerCase(c))) {
                    return c2 - c;
                }
                ++n3;
                ++n4;
            }
            n3 = n - n2;
            if (n3 == 0) {
                return string.compareTo(string2);
            }
            return n3;
        }
    }

    private class TableSelectionListener
    extends SelectionAdapter {
        private TableSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            ParametersCompositeContainer.this.updateButtonStatus();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ParametersCompositeContainer.this.updateButtonStatus();
        }
    }
}

