/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.IEditableElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ResourceTypeSectionPart
extends SectionPart {
    private static final Logger logger = Logger.getLogger(ResourceTypeSectionPart.class);
    protected Composite sectionClient;
    protected IAdaptable input;
    protected boolean allowMarkDirty = false;
    protected IEditorPart editorPart;

    public ResourceTypeSectionPart(IEditorPart iEditorPart, Composite composite, FormToolkit formToolkit, int n) {
        super(composite, formToolkit, n);
        this.editorPart = iEditorPart;
    }

    public void initialize(IManagedForm iManagedForm) {
        super.initialize(iManagedForm);
        this.createSectionControls(iManagedForm);
        this.initializeSectionLayout(iManagedForm);
        this.allowMarkDirty = true;
    }

    public void refresh() {
        super.refresh();
        this.allowMarkDirty = false;
        this.populateSectionData();
        this.setWidgetPermissions();
        this.allowMarkDirty = true;
    }

    public void markDirty() {
        if (this.allowMarkDirty) {
            super.markDirty();
        }
    }

    public boolean setFormInput(Object object) {
        if (object instanceof ResourceTypeEditorInput) {
            this.input = (ResourceTypeEditorInput)object;
            this.markStale();
            return true;
        }
        return false;
    }

    protected void createSectionControls(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Section section = this.getSection();
        this.sectionClient = formToolkit.createComposite((Composite)section, 64);
        formToolkit.paintBordersFor(this.sectionClient);
        section.setClient((Control)this.sectionClient);
        this.createSectionClientControls(iManagedForm);
    }

    protected abstract void createSectionClientControls(IManagedForm var1);

    protected void initializeSectionLayout(IManagedForm iManagedForm) {
        this.sectionClient.setLayoutData((Object)this.createGridData());
        this.initializeSectionClientLayout(iManagedForm);
    }

    protected abstract void initializeSectionClientLayout(IManagedForm var1);

    protected GridLayout createGridLayout(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginRight = 2;
        gridLayout.marginLeft = 2;
        gridLayout.marginBottom = 2;
        gridLayout.marginTop = 2;
        return gridLayout;
    }

    protected GridData createGridData() {
        return new GridData(1, 1, false, false);
    }

    protected GridData createLabelGridData() {
        GridData gridData = new GridData(1, 1, false, false);
        gridData.verticalIndent = 2;
        return gridData;
    }

    protected abstract void populateSectionData();

    protected abstract void setWidgetPermissions();

    protected ResourceType getResourceType() {
        return this.input != null ? (ResourceType)this.input.getAdapter(ResourceType.class) : null;
    }

    protected Message getMessage() {
        return this.input != null ? (Message)this.input.getAdapter(Message.class) : null;
    }

    protected boolean isInputEditable() {
        IEditableElement iEditableElement;
        boolean bl = true;
        if (this.input != null && (iEditableElement = (IEditableElement)this.input.getAdapter(IEditableElement.class)) != null) {
            bl = iEditableElement.canEdit();
        }
        return bl;
    }

    protected int getDefaultClassNameTextWidth() {
        return 380;
    }

    protected String formatValue(String string, boolean bl) {
        String string2 = null;
        string2 = string == null ? "" : (bl ? string.trim() : string);
        return string2;
    }

    protected List<ConnectionType> getAvailableConnectionTypes() {
        List<ConnectionType> list = null;
        try {
            ServiceFactory serviceFactory = ServiceFactory.createFactory();
            IResourceTypeService iResourceTypeService = serviceFactory.createResourceTypeService();
            list = iResourceTypeService.getAllConnectionTypes();
            if (list == null) {
                list = new ArrayList<ConnectionType>();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to get the list of available Connection Types.", (Throwable)exception);
        }
        return list;
    }
}

