/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.model.TaskNode;

public class AbstractTaskNode
extends TaskNode
implements IResourceGroupElement,
IDueDateElement {
    private static final String NODE_ENTER_EVENT = "node-enter";
    private static final String NODE_LEAVE_EVENT = "node-leave";
    ResourceGroup resourceGroup;
    ActionElement actionElement;

    public void setResourceGroup(ResourceGroup resourceGroup) {
        ResourceGroup resourceGroup2 = this.resourceGroup;
        this.resourceGroup = resourceGroup;
        this.firePropertyChange("resourceGroupAdd", (Object)resourceGroup2, (Object)resourceGroup);
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public void setScript(Script script) {
        ActionElement actionElement = this.actionElement;
        this.actionElement = script;
        this.firePropertyChange("script", actionElement, script);
    }

    public Script getScript() {
        if (this.actionElement instanceof Script) {
            return (Script)this.actionElement;
        }
        return null;
    }

    public String getDueDate() {
        CreateTimer createTimer = null;
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            if (event.getType().equals(NODE_ENTER_EVENT)) {
                ActionElement[] actionElementArray = event.getActionElements();
                int n3 = actionElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionElement actionElement = actionElementArray[n4];
                    if (actionElement instanceof CreateTimer) {
                        createTimer = (CreateTimer)actionElement;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (createTimer == null) {
            return null;
        }
        return createTimer.getDueDate();
    }

    public void setDueDate(String string) {
        if (string == null) {
            this.removeTimerEvents();
            return;
        }
        CreateTimer createTimer = this.getNodeEnterCreateTimer();
        if (createTimer == null) {
            return;
        }
        createTimer.setDueDate(string);
    }

    public void setAction(Action action) {
        ActionElement actionElement = this.actionElement;
        this.actionElement = action;
        this.firePropertyChange("action", actionElement, action);
    }

    public Action getAction() {
        if (this.actionElement instanceof Action) {
            return (Action)this.actionElement;
        }
        return null;
    }

    public void setCreateTimer(CreateTimer createTimer) {
        ActionElement actionElement = this.actionElement;
        this.actionElement = createTimer;
        this.firePropertyChange("createTimer", actionElement, createTimer);
    }

    public CreateTimer getCreateTimer() {
        if (this.actionElement instanceof CreateTimer) {
            return (CreateTimer)this.actionElement;
        }
        return null;
    }

    public void setCancelTimer(CancelTimer cancelTimer) {
        ActionElement actionElement = this.actionElement;
        this.actionElement = cancelTimer;
        this.firePropertyChange("cancelTimer", actionElement, cancelTimer);
    }

    public CancelTimer getCancelTimer() {
        if (this.actionElement instanceof CancelTimer) {
            return (CancelTimer)this.actionElement;
        }
        return null;
    }

    private void removeTimerEvents() {
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionElement actionElement;
            int n3;
            int n4;
            ActionElement[] actionElementArray;
            Event event = eventArray[n2];
            if (event.getType().equals(NODE_ENTER_EVENT)) {
                actionElementArray = event.getActionElements();
                n4 = actionElementArray.length;
                n3 = 0;
                while (n3 < n4) {
                    actionElement = actionElementArray[n3];
                    if (actionElement instanceof CreateTimer) {
                        event.removeActionElement(actionElement);
                    }
                    ++n3;
                }
                if (event.getActionElements().length == 0) {
                    this.removeEvent(event);
                }
            }
            if (event.getType().equals(NODE_LEAVE_EVENT)) {
                actionElementArray = event.getActionElements();
                n4 = actionElementArray.length;
                n3 = 0;
                while (n3 < n4) {
                    actionElement = actionElementArray[n3];
                    if (actionElement instanceof Action && ((Action)actionElement).getRefName() != null && ((Action)actionElement).getRefName().equals("timer-delete")) {
                        event.removeActionElement(actionElement);
                    }
                    ++n3;
                }
                if (event.getActionElements().length == 0) {
                    this.removeEvent(event);
                }
            }
            ++n2;
        }
    }

    private CreateTimer getNodeEnterCreateTimer() {
        Event event = this.AddTimerActionToEvent(NODE_ENTER_EVENT, "timer-fire");
        this.AddTimerActionToEvent(NODE_LEAVE_EVENT, "timer-delete");
        ActionElement[] actionElementArray = event.getActionElements();
        int n = actionElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionElement actionElement = actionElementArray[n2];
            if (actionElement instanceof CreateTimer) {
                return (CreateTimer)actionElement;
            }
            ++n2;
        }
        return null;
    }

    private Event AddTimerActionToEvent(String string, String string2) {
        Event event;
        boolean bl = false;
        Event event2 = null;
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            event = eventArray[n2];
            if (event.getType().equals(string)) {
                event2 = event;
            }
            ++n2;
        }
        if (event2 == null) {
            event2 = (Event)this.getFactory().createById("org.jbpm.gd.jpdl.event");
            this.addEvent(event2);
            event2.setType(string);
            bl = true;
        }
        event = null;
        if (string.equals(NODE_ENTER_EVENT)) {
            CreateTimer createTimer = null;
            if (!bl) {
                ActionElement[] actionElementArray = event2.getActionElements();
                int n3 = actionElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionElement actionElement = actionElementArray[n4];
                    if (actionElement instanceof CreateTimer) {
                        createTimer = (CreateTimer)actionElement;
                    }
                    ++n4;
                }
            }
            if (createTimer == null) {
                createTimer = (CreateTimer)this.getFactory().createById("org.jbpm.gd.jpdl.createTimer");
                event2.addActionElement((ActionElement)createTimer);
            }
            if ((event = createTimer.getAction()) == null) {
                event = (Action)this.getFactory().createById("org.jbpm.gd.jpdl.action");
                createTimer.setAction((Action)event);
            }
        } else if (string.equals(NODE_LEAVE_EVENT)) {
            ActionElement[] actionElementArray = event2.getActionElements();
            int n5 = actionElementArray.length;
            n = 0;
            while (n < n5) {
                ActionElement actionElement = actionElementArray[n];
                if (actionElement instanceof Action && ((Action)actionElement).getRefName() != null && ((Action)actionElement).getRefName().equals(string2)) {
                    event = (Action)actionElement;
                }
                ++n;
            }
            if (event == null) {
                event = (Action)this.getFactory().createById("org.jbpm.gd.jpdl.action");
                event2.addActionElement((ActionElement)event);
            }
        }
        event.setRefName(string2);
        return event2;
    }
}

