/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinition
extends AbstractNode
implements IResourceGroupElement,
IMessageNodeContainer,
IDurationElement,
IDueDateElement,
NodeElementContainer {
    private long id;
    private AbstractNode node;
    private String definitionName;
    private long resourceType;
    private NodeDefinitionType nodeType;
    private List<WPVariable> variables = new ArrayList<WPVariable>();

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        long l2 = this.id;
        this.id = l;
        this.firePropertyChange("id", l2, l);
    }

    public void setName(String string) {
        super.setName(string);
        if (this.node != null) {
            this.node.setName(string);
        }
    }

    public AbstractNode getNode() {
        return this.node;
    }

    public void setNode(AbstractNode abstractNode) {
        AbstractNode abstractNode2 = this.node;
        this.node = abstractNode;
        if (abstractNode instanceof AutomaticTaskNode) {
            this.firePropertyChange("auto-task", abstractNode2, abstractNode);
        } else {
            this.firePropertyChange("super-state", abstractNode2, abstractNode);
        }
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public void setDefinitionName(String string) {
        String string2 = this.definitionName;
        this.definitionName = string;
        this.firePropertyChange("definitionName", string2, string);
    }

    public NodeDefinitionType getNodeType() {
        if (this.nodeType != null) {
            return this.nodeType;
        }
        if (this.node instanceof NodeElementContainer) {
            return NodeDefinitionType.SuperState;
        }
        return NodeDefinitionType.SingleNode;
    }

    public void setNodeType(NodeDefinitionType nodeDefinitionType) {
        this.nodeType = nodeDefinitionType;
    }

    @Override
    public long getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(long l) {
        String string = this.definitionName;
        this.resourceType = l;
        this.firePropertyChange("resourceType", string, l);
    }

    @Override
    public ResourceGroup getResourceGroup() {
        if (this.node == null) {
            return null;
        }
        return ((IResourceGroupElement)this.node).getResourceGroup();
    }

    @Override
    public void setResourceGroup(ResourceGroup resourceGroup) {
        ((IResourceGroupElement)this.node).setResourceGroup(resourceGroup);
    }

    @Override
    public String getUid() {
        if (this.node instanceof IMessageContainer) {
            return ((IMessageContainer)this.node).getUid();
        }
        return null;
    }

    @Override
    public void setUid(String string) {
        if (this.node instanceof IMessageContainer) {
            ((IMessageContainer)this.node).setUid(string);
        }
    }

    @Override
    public List<WPVariable> getVariables() {
        if (this.node instanceof NodeElementContainer) {
            return this.variables;
        }
        if (this.node == null) {
            return new ArrayList<WPVariable>();
        }
        IMessageContainer iMessageContainer = (IMessageContainer)this.node;
        List<WPVariable> list = iMessageContainer.getIncomingVariables();
        list.addAll(iMessageContainer.getOutgoingVariables());
        list.addAll(this.getNodeCompositeKeys());
        return list;
    }

    @Override
    public void addVariable(WPVariable wPVariable) {
        if (!(this.node instanceof NodeElementContainer)) {
            return;
        }
        this.variables.add(wPVariable);
        this.firePropertyChange("variableAdd", null, (Object)wPVariable);
    }

    @Override
    public WPVariable removeVariable(String string) {
        WPVariable wPVariable = null;
        if (this.node instanceof NodeElementContainer) {
            for (WPVariable wPVariable2 : this.variables) {
                if (!wPVariable2.getMappedName().equals(string)) continue;
                wPVariable = this.variables.remove(this.variables.indexOf((Object)wPVariable2));
                this.firePropertyChange("variableRemove", (Object)wPVariable2, null);
                break;
            }
        }
        return wPVariable;
    }

    @Override
    public List<NameValuePair> getConstants() {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        if (this.node == null) {
            return arrayList;
        }
        if (this.node instanceof NodeElementContainer) {
            NodeElementContainer nodeElementContainer = (NodeElementContainer)this.node;
            NodeElement[] nodeElementArray = nodeElementContainer.getNodeElements();
            int n = nodeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeElement nodeElement = nodeElementArray[n2];
                if (nodeElement instanceof IMessageNodeContainer) {
                    IMessageNodeContainer iMessageNodeContainer = (IMessageNodeContainer)nodeElement;
                    arrayList.addAll(iMessageNodeContainer.getConstants());
                }
                ++n2;
            }
        } else {
            IMessageContainer iMessageContainer = (IMessageContainer)this.node;
            for (String string : iMessageContainer.getConstants().keySet()) {
                arrayList.add(new NameValuePair(string, iMessageContainer.getConstants().get(string)));
            }
        }
        return arrayList;
    }

    @Override
    public void setConstantValue(String string, String string2) {
        if (this.node instanceof NodeElementContainer) {
            throw new StudioRuntimeException("Can not set constant values for super-states.");
        }
        ((IMessageContainer)this.node).setConstantValue(string, string2);
    }

    @Override
    public String getCompositeKey(String string) {
        if (this.node instanceof NodeElementContainer) {
            return null;
        }
        return ((IMessageContainer)this.node).getCompositeKey(string);
    }

    @Override
    public void setCompositeKey(String string, String string2) {
        if (this.node instanceof NodeElementContainer) {
            throw new StudioRuntimeException("Can not set composite key for a super-state.");
        }
        ((IMessageContainer)this.node).setCompositeKey(string, string2);
    }

    @Override
    public Map<String, String> getCompositeKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.node == null) {
            return hashMap;
        }
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer iMessageContainer = (IMessageContainer)this.node;
            hashMap.putAll(iMessageContainer.getCompositeKeys());
        }
        return hashMap;
    }

    @Override
    public List<WPVariable> getIncomingVariables() {
        ArrayList<WPVariable> arrayList = new ArrayList<WPVariable>();
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer iMessageContainer = (IMessageContainer)this.node;
            this.addIncomingVariablesFromNode(arrayList, iMessageContainer);
        }
        return arrayList;
    }

    @Override
    public List<WPVariable> getOutgoingVariables() {
        ArrayList<WPVariable> arrayList = new ArrayList<WPVariable>();
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer iMessageContainer = (IMessageContainer)this.node;
            this.addOutgoingVariablesFromNode(arrayList, iMessageContainer);
        }
        return arrayList;
    }

    @Override
    public String getDuration() {
        if (this.node == null) {
            return "";
        }
        return ((IDurationElement)this.node).getDuration();
    }

    @Override
    public String getTaskDuration() {
        if (this.node == null) {
            return "";
        }
        return ((IDurationElement)this.node).getTaskDuration();
    }

    @Override
    public void setDuration(String string) {
        ((IDurationElement)this.node).setDuration(string);
    }

    @Override
    public void setTaskDuration(String string) {
        ((IDurationElement)this.node).setTaskDuration(string);
    }

    @Override
    public String getDueDate() {
        if (this.node == null) {
            return "";
        }
        return ((IDueDateElement)this.node).getDueDate();
    }

    @Override
    public void setDueDate(String string) {
        if (this.node != null) {
            ((IDueDateElement)this.node).setDueDate(string);
        }
    }

    public void addNodeElement(NodeElement nodeElement) {
        if (this.node instanceof NodeGroup) {
            ((NodeGroup)this.node).addNodeElement(nodeElement);
            this.firePropertyChange("nodeElementAdd", null, nodeElement);
        }
    }

    public boolean canAdd(NodeElement nodeElement) {
        if (this.node instanceof NodeGroup) {
            return nodeElement.isPossibleChildOf((NodeElementContainer)this);
        }
        return false;
    }

    public NodeElement getNodeElementByName(String string) {
        if (this.node instanceof NodeGroup) {
            return ((NodeGroup)this.node).getNodeElementByName(string);
        }
        if (this.node.getName().equals(string)) {
            return this.node;
        }
        return null;
    }

    public NodeElement[] getNodeElements() {
        if (this.node instanceof NodeGroup) {
            return ((NodeGroup)this.node).getNodeElements();
        }
        return new NodeElement[]{this.node};
    }

    public void removeNodeElement(NodeElement nodeElement) {
        if (this.node instanceof NodeGroup) {
            ((NodeGroup)this.node).removeNodeElement(nodeElement);
            this.firePropertyChange("nodeElementRemove", nodeElement, null);
        }
    }

    private void addIncomingVariablesFromNode(List<WPVariable> list, IMessageContainer iMessageContainer) {
        if (iMessageContainer == null) {
            return;
        }
        list.addAll(iMessageContainer.getIncomingVariables());
    }

    private void addOutgoingVariablesFromNode(List<WPVariable> list, IMessageContainer iMessageContainer) {
        if (iMessageContainer == null) {
            return;
        }
        list.addAll(iMessageContainer.getOutgoingVariables());
    }

    private List<WPVariable> getNodeCompositeKeys() {
        ArrayList<WPVariable> arrayList = new ArrayList<WPVariable>();
        if (this.node == null) {
            return arrayList;
        }
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer iMessageContainer = (IMessageContainer)this.node;
            for (String string : iMessageContainer.getCompositeKeys().keySet()) {
                WPVariable wPVariable = this.createWPVariable();
                wPVariable.setMappedName(string);
                wPVariable.setName(iMessageContainer.getCompositeKeys().get(string));
                arrayList.add(wPVariable);
            }
        }
        return arrayList;
    }

    private WPVariable createWPVariable() {
        return (WPVariable)this.getFactory().createById("org.jbpm.gd.jpdl.variable");
    }
}

