/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.jbpm.gd.jpdl.model.Variable;

public abstract class AbstractInVariableWrapper
extends AbstractVariableTableItemWrapper {
    protected Button compositeButton;
    protected CCombo variableCombo;

    public AbstractInVariableWrapper(Table table, Variable variable) {
        super(table, variable);
        this.initializeCompositeButton(table);
        this.initializeVariableCombo(table);
    }

    public AbstractInVariableWrapper(Table table, String string) {
        super(table, new WPVariable());
        this.variable.setMappedName(string);
        this.initializeCompositeButton(table);
        this.initializeVariableCombo(table);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        super.widgetDisposed(disposeEvent);
        if (this.compositeButton == null || this.compositeButton.isDisposed()) {
            return;
        }
        this.compositeButton.removeSelectionListener((SelectionListener)this);
        this.compositeButton.removeFocusListener((FocusListener)this);
        this.compositeButton.dispose();
        if (this.variableCombo == null || this.variableCombo.isDisposed()) {
            return;
        }
        this.variableCombo.removeSelectionListener((SelectionListener)this);
        this.variableCombo.removeFocusListener((FocusListener)this);
        this.variableCombo.dispose();
    }

    private void initializeCompositeButton(Table table) {
        this.compositeButton = this.createButton(table, 3);
        this.compositeButton.addSelectionListener((SelectionListener)this);
        this.compositeButton.addFocusListener((FocusListener)this);
        this.compositeButton.setEnabled(false);
        this.compositeButton.pack();
    }

    private void initializeVariableCombo(Table table) {
        this.variableCombo = this.createCombo(table, 2);
        this.variableCombo.addSelectionListener((SelectionListener)this);
        this.variableCombo.addFocusListener((FocusListener)this);
        this.variableCombo.setEnabled(false);
        if (this.variableCombo.getText().equals("") && this.variable.getName() != null) {
            this.variableCombo.setText(this.variable.getName());
        }
    }
}

