/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.model.Variable;

public abstract class AbstractOutVariableWrapper
extends AbstractVariableTableItemWrapper {
    protected Button attachmentButton;
    protected CCombo variableCombo;
    protected Text valueText;

    public AbstractOutVariableWrapper(Table table, Variable variable) {
        super(table, variable);
        this.initializeValueText(table);
        this.initializeAttachmentButton(table);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.variableCombo) {
            this.setVariableName(this.variableCombo.getText());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        super.widgetDefaultSelected(selectionEvent);
        if (selectionEvent.widget == this.variableCombo) {
            this.setVariableName(this.variableCombo.getText());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.variableCombo) {
            this.setVariableName(this.variableCombo.getText());
        } else {
            super.focusLost(focusEvent);
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        super.widgetDisposed(disposeEvent);
        this.attachmentButton.removeSelectionListener((SelectionListener)this);
        this.attachmentButton.removeFocusListener((FocusListener)this);
        this.attachmentButton.dispose();
        this.valueText.removeSelectionListener((SelectionListener)this);
        this.valueText.removeFocusListener((FocusListener)this);
        this.valueText.dispose();
        if (this.variableCombo != null && !this.variableCombo.isDisposed()) {
            this.variableCombo.removeSelectionListener((SelectionListener)this);
            this.variableCombo.removeFocusListener((FocusListener)this);
            this.variableCombo.dispose();
        }
    }

    private void initializeValueText(Table table) {
        this.valueText = this.createText(table, 3);
        this.valueText.addSelectionListener((SelectionListener)this);
        this.valueText.addFocusListener((FocusListener)this);
        this.valueText.setEditable(false);
    }

    private void initializeAttachmentButton(Table table) {
        this.attachmentButton = this.createButton(table, 2);
        this.attachmentButton.addSelectionListener((SelectionListener)this);
        this.attachmentButton.addFocusListener((FocusListener)this);
        this.attachmentButton.setSelection(this.variable.isAttachment());
        this.attachmentButton.setEnabled(false);
    }

    private void setVariableName(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        if (this.variable.getMappedName() == null || this.variable.getMappedName().equals("")) {
            this.variable.setMappedName(this.variable.getName());
        }
        this.variable.setName(string);
    }
}

