/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractOutVariableWrapper;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jbpm.gd.jpdl.model.Variable;

public class EditableOutVarTableItemWrapper
extends AbstractOutVariableWrapper {
    private static final String ATTACHMENT_ACCESS = "attachment";
    private Button constantButton;
    private IMessageContainer messageContainer;

    public EditableOutVarTableItemWrapper(Table table, Variable variable, IMessageContainer iMessageContainer) {
        super(table, variable);
        this.messageContainer = iMessageContainer;
        this.initializeConstantButton(table);
        this.initializeControls();
    }

    public boolean isConstant() {
        return this.constantButton.getSelection();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.mappedNameText) {
            if (!this.mappedNameText.getText().equals(this.variable.getMappedName()) && this.hasVariable(this.mappedNameText.getText())) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("This message already contains a variable " + this.mappedNameText.getText() + "."));
                this.mappedNameText.setText(this.variable.getMappedName());
                return;
            }
            if (this.constantButton.getSelection()) {
                this.messageContainer.setConstantValue(this.variable.getMappedName(), null);
                this.messageContainer.setConstantValue(this.mappedNameText.getText(), this.valueText.getText());
            }
        } else if (focusEvent.widget == this.valueText && this.constantButton.getSelection()) {
            this.messageContainer.setConstantValue(this.getMappedName(), this.valueText.getText());
        }
        super.focusLost(focusEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.constantButton) {
            if (this.constantButton.getSelection()) {
                this.valueText.setEditable(true);
                this.attachmentButton.setSelection(false);
                this.attachmentButton.setEnabled(false);
                this.messageContainer.setConstantValue(this.getMappedName(), this.valueText.getText());
                this.messageContainer.removeVariable(this.getMappedName());
            } else {
                this.valueText.setText("");
                this.valueText.setEditable(false);
                this.attachmentButton.setSelection(false);
                this.attachmentButton.setEnabled(true);
                this.messageContainer.setConstantValue(this.getMappedName(), null);
                this.messageContainer.addVariable(this.variable);
            }
        } else if (selectionEvent.widget == this.attachmentButton) {
            if (this.attachmentButton.getSelection() && this.messageContainer.hasAttachment()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Message can only send one attachment.");
                this.attachmentButton.setSelection(false);
                return;
            }
            this.variable.setAccess(this.calculateAccessString());
            this.messageContainer.updateActionHandler();
            if (this.constantButton.getSelection()) {
                this.constantButton.setSelection(!this.attachmentButton.getSelection());
            }
            this.constantButton.setEnabled(!this.attachmentButton.getSelection());
        } else {
            super.widgetSelected(selectionEvent);
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        super.widgetDisposed(disposeEvent);
        this.constantButton.removeSelectionListener((SelectionListener)this);
        this.constantButton.removeFocusListener((FocusListener)this);
        this.constantButton.dispose();
    }

    private void initializeControls() {
        this.mappedNameText.setEditable(true);
        boolean bl = this.constantButton.getSelection();
        this.attachmentButton.setEnabled(!bl && Utility.isOutgoingMessage(this.messageContainer.getUid()));
        this.valueText.setEditable(bl);
        if (bl) {
            this.valueText.setText(this.messageContainer.getConstantValue(this.variable.getMappedName()));
        }
    }

    private void initializeConstantButton(Table table) {
        this.constantButton = this.createButton(table, 4);
        this.constantButton.addSelectionListener((SelectionListener)this);
        this.constantButton.addFocusListener((FocusListener)this);
        this.constantButton.setSelection(this.messageContainer.getConstantValue(this.variable.getMappedName()) != null);
    }

    private String calculateAccessString() {
        String string = this.variable.getAccess();
        if (this.attachmentButton.getSelection()) {
            if (string.indexOf(ATTACHMENT_ACCESS) != -1) {
                return string;
            }
            if (string != null && string.length() > 0) {
                string = String.valueOf(string) + ", ";
            }
            return String.valueOf(string) + ATTACHMENT_ACCESS;
        }
        return string.substring(0, string.indexOf(", attachment"));
    }

    private boolean hasVariable(String string) {
        for (WPVariable wPVariable : this.messageContainer.getOutgoingVariables()) {
            if (!wPVariable.getMappedName().equals(string)) continue;
            return true;
        }
        for (WPVariable wPVariable : this.messageContainer.getIncomingVariables()) {
            if (!wPVariable.getMappedName().equals(string)) continue;
            return true;
        }
        return this.messageContainer.getConstantValue(string) != null || this.messageContainer.getCompositeKey(string) != null;
    }
}

