/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractMessageContainerComposite;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.EditableInVarTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.EditableOutVarTableItemWrapper;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.model.Variable;

public class MessageContainerComposite
extends AbstractMessageContainerComposite {
    protected IMessageContainer messageContainer;
    private String[] outColumnTitles = null;
    private String[] inColumnTitles = null;
    private Button addOutVarButton;
    private Button removeOutVarButton;
    private Button addInVarButton;
    private Button removeInVarButton;

    public static MessageContainerComposite create(FormToolkit formToolkit, Composite composite, String[] stringArray, String[] stringArray2) {
        MessageContainerComposite messageContainerComposite = new MessageContainerComposite();
        messageContainerComposite.init(formToolkit, stringArray, stringArray2);
        messageContainerComposite.create(composite);
        return messageContainerComposite;
    }

    public static MessageContainerComposite create(FormToolkit formToolkit, Composite composite) {
        return MessageContainerComposite.create(formToolkit, composite, new String[]{"Name", "Attachment", "Value", "Constant"}, new String[]{"Name", "Process variable", "Composite Key"});
    }

    protected void init(FormToolkit formToolkit, String[] stringArray, String[] stringArray2) {
        super.init(formToolkit);
        this.outColumnTitles = stringArray;
        this.inColumnTitles = stringArray2;
    }

    protected void create(Composite composite) {
        super.create(composite);
        this.addOutVarButton = this.widgetFactory.createButton(composite, "Add", 8);
        this.removeOutVarButton = this.widgetFactory.createButton(composite, "Remove", 8);
        this.addOutVarButton.setLayoutData((Object)this.createAddOutButtonLayoutData());
        this.removeOutVarButton.setLayoutData((Object)this.createRemoveOutButtonLayoutData());
        this.addInVarButton = this.widgetFactory.createButton(composite, "Add", 8);
        this.removeInVarButton = this.widgetFactory.createButton(composite, "Remove", 8);
        this.addInVarButton.setLayoutData((Object)this.createAddInButtonLayoutData());
        this.removeInVarButton.setLayoutData((Object)this.createRemoveInButtonLayoutData());
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.addOutVarButton) {
            this.handleAddOutVarButtonSelected();
        } else if (selectionEvent.widget == this.removeOutVarButton) {
            this.handleRemoveOutVarButtonSelected();
        } else if (selectionEvent.widget == this.addInVarButton) {
            this.handleAddInVarButtonSelected();
        } else if (selectionEvent.widget == this.removeInVarButton) {
            this.handleRemoveInVarButtonSelected();
        }
    }

    public void setMessageContainer(IMessageContainer iMessageContainer) {
        this.unhookListeners();
        this.messageContainer = iMessageContainer;
        this.clearControls();
        if (iMessageContainer != null) {
            this.updateControls();
            this.hookListeners();
            boolean bl = iMessageContainer.getUid() != null && iMessageContainer.getUid().length() > 0;
            this.addOutVarButton.setEnabled(bl);
            this.addInVarButton.setEnabled(bl);
        }
    }

    protected void hookListeners() {
        super.hookListeners();
        this.addOutVarButton.addSelectionListener((SelectionListener)this);
        this.removeOutVarButton.addSelectionListener((SelectionListener)this);
        this.addInVarButton.addSelectionListener((SelectionListener)this);
        this.removeInVarButton.addSelectionListener((SelectionListener)this);
    }

    protected void unhookListeners() {
        super.unhookListeners();
        this.addOutVarButton.removeSelectionListener((SelectionListener)this);
        this.removeOutVarButton.removeSelectionListener((SelectionListener)this);
        this.addInVarButton.removeSelectionListener((SelectionListener)this);
        this.removeInVarButton.removeSelectionListener((SelectionListener)this);
    }

    protected void clearControls() {
        super.clearControls();
        this.addOutVarButton.setEnabled(false);
        this.removeOutVarButton.setEnabled(false);
        this.addInVarButton.setEnabled(false);
        this.removeInVarButton.setEnabled(false);
    }

    protected void updateControls() {
        this.addOutVarButton.setEnabled(true);
        this.addInVarButton.setEnabled(true);
        super.updateControls();
    }

    protected void initializeOutTableColumns() {
        TableLayout tableLayout = (TableLayout)this.outVariablesTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        tableColumn.setText("");
        ColumnWeightData columnWeightData = new ColumnWeightData(0);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.outVariablesTable, 16384);
        tableColumn2.setText(this.outColumnTitles[0]);
        tableColumn2.pack();
        ColumnWeightData columnWeightData2 = new ColumnWeightData(15);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        TableColumn tableColumn3 = new TableColumn(this.outVariablesTable, 16384);
        tableColumn3.setText(this.outColumnTitles[1]);
        tableColumn3.setAlignment(0x1000000);
        tableColumn3.pack();
        ColumnWeightData columnWeightData3 = new ColumnWeightData(9);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        TableColumn tableColumn4 = new TableColumn(this.outVariablesTable, 0x1000000);
        tableColumn4.setText(this.outColumnTitles[2]);
        tableColumn4.pack();
        ColumnWeightData columnWeightData4 = new ColumnWeightData(12);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData4);
        TableColumn tableColumn5 = new TableColumn(this.outVariablesTable, 0x1000000);
        tableColumn5.setText(this.outColumnTitles[3]);
        tableColumn5.pack();
        ColumnWeightData columnWeightData5 = new ColumnWeightData(12);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData5);
    }

    protected void initializeInTableColumns() {
        TableLayout tableLayout = (TableLayout)this.inVariablesTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.inVariablesTable, 0x1000000);
        tableColumn.setText("");
        ColumnWeightData columnWeightData = new ColumnWeightData(0);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.inVariablesTable, 16384);
        tableColumn2.setText(this.inColumnTitles[0]);
        tableColumn2.pack();
        ColumnWeightData columnWeightData2 = new ColumnWeightData(14);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        TableColumn tableColumn3 = new TableColumn(this.inVariablesTable, 16384);
        tableColumn3.setText(this.inColumnTitles[1]);
        tableColumn3.pack();
        ColumnWeightData columnWeightData3 = new ColumnWeightData(14);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        TableColumn tableColumn4 = new TableColumn(this.inVariablesTable, 0x1000000);
        tableColumn4.setText(this.inColumnTitles[2]);
        tableColumn4.pack();
        ColumnWeightData columnWeightData4 = new ColumnWeightData(6);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData4);
    }

    protected void refreshTables() {
        AbstractVariableTableItemWrapper abstractVariableTableItemWrapper;
        Object object;
        this.outVariablesTable.removeAll();
        List<WPVariable> list = this.messageContainer.getOutgoingVariables();
        for (WPVariable wPVariable : list) {
            object = new EditableOutVarTableItemWrapper(this.outVariablesTable, wPVariable, this.messageContainer);
            this.outVariablesTable.setSelection(((AbstractVariableTableItemWrapper)object).getTableItem());
            ((AbstractVariableTableItemWrapper)object).editCell(1);
        }
        for (String string : this.messageContainer.getConstants().keySet()) {
            object = this.createVariable(this.messageContainer.getFactory());
            object.setMappedName(string);
            object.setAccess("read");
            abstractVariableTableItemWrapper = new EditableOutVarTableItemWrapper(this.outVariablesTable, (Variable)object, this.messageContainer);
            this.outVariablesTable.setSelection(abstractVariableTableItemWrapper.getTableItem());
            abstractVariableTableItemWrapper.editCell(1);
        }
        this.inVariablesTable.removeAll();
        list = this.messageContainer.getIncomingVariables();
        for (WPVariable wPVariable : list) {
            abstractVariableTableItemWrapper = new EditableInVarTableItemWrapper(this.inVariablesTable, wPVariable, this.messageContainer);
            this.inVariablesTable.setSelection(abstractVariableTableItemWrapper.getTableItem());
            abstractVariableTableItemWrapper.editCell(1);
        }
        for (String string : this.messageContainer.getCompositeKeys().keySet()) {
            object = this.createVariable(this.messageContainer.getFactory());
            object.setMappedName(string);
            object.setAccess("write");
            abstractVariableTableItemWrapper = new EditableInVarTableItemWrapper(this.inVariablesTable, (Variable)object, this.messageContainer);
            this.inVariablesTable.setSelection(abstractVariableTableItemWrapper.getTableItem());
            abstractVariableTableItemWrapper.editCell(1);
        }
        this.removeOutVarButton.setEnabled(this.outVariablesTable.getSelectionIndex() != -1);
        this.removeInVarButton.setEnabled(this.inVariablesTable.getSelectionIndex() != -1);
    }

    private FormData createAddOutButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.outVariablesTable, 0);
        formData.top.alignment = 128;
        formData.left = new FormAttachment((Control)this.removeOutVarButton, 0);
        formData.left.alignment = 16384;
        formData.right = new FormAttachment(100, -5);
        return formData;
    }

    private FormData createRemoveOutButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.addOutVarButton, 5);
        formData.right = new FormAttachment(100, -5);
        return formData;
    }

    private FormData createAddInButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.inVariablesTable, 0);
        formData.top.alignment = 128;
        formData.left = new FormAttachment((Control)this.removeInVarButton, 0);
        formData.left.alignment = 16384;
        formData.right = new FormAttachment(100, -4);
        return formData;
    }

    private FormData createRemoveInButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.addInVarButton, 5);
        formData.right = new FormAttachment(100, -4);
        return formData;
    }

    private void handleAddOutVarButtonSelected() {
        WPVariable wPVariable = this.createVariable(this.messageContainer.getFactory());
        wPVariable.setMappedName(this.getNextAvailableVariableName());
        wPVariable.setAccess("read");
        this.messageContainer.addVariable(wPVariable);
        EditableOutVarTableItemWrapper editableOutVarTableItemWrapper = new EditableOutVarTableItemWrapper(this.outVariablesTable, wPVariable, this.messageContainer);
        this.outVariablesTable.setSelection(editableOutVarTableItemWrapper.getTableItem());
        editableOutVarTableItemWrapper.editCell(1);
        this.removeOutVarButton.setEnabled(this.outVariablesTable.getSelectionIndex() != -1);
    }

    private void handleRemoveOutVarButtonSelected() {
        TableItem tableItem = this.outVariablesTable.getItem(this.outVariablesTable.getSelectionIndex());
        EditableOutVarTableItemWrapper editableOutVarTableItemWrapper = (EditableOutVarTableItemWrapper)tableItem.getData();
        WPVariable wPVariable = (WPVariable)editableOutVarTableItemWrapper.getVariable();
        if (editableOutVarTableItemWrapper.isConstant()) {
            this.messageContainer.setConstantValue(wPVariable.getMappedName(), null);
        } else {
            this.messageContainer.removeVariable(editableOutVarTableItemWrapper.getVariable().getMappedName());
        }
        this.refreshTables();
        this.removeOutVarButton.setEnabled(this.outVariablesTable.getSelectionIndex() != -1);
    }

    private void handleAddInVarButtonSelected() {
        WPVariable wPVariable = this.createVariable(this.messageContainer.getFactory());
        wPVariable.setMappedName(this.getNextAvailableVariableName());
        wPVariable.setAccess("write");
        this.messageContainer.addVariable(wPVariable);
        EditableInVarTableItemWrapper editableInVarTableItemWrapper = new EditableInVarTableItemWrapper(this.inVariablesTable, wPVariable, this.messageContainer);
        this.inVariablesTable.setSelection(editableInVarTableItemWrapper.getTableItem());
        editableInVarTableItemWrapper.editCell(1);
        this.removeInVarButton.setEnabled(this.inVariablesTable.getSelectionIndex() != -1);
    }

    private void handleRemoveInVarButtonSelected() {
        TableItem tableItem = this.inVariablesTable.getItem(this.inVariablesTable.getSelectionIndex());
        EditableInVarTableItemWrapper editableInVarTableItemWrapper = (EditableInVarTableItemWrapper)tableItem.getData();
        WPVariable wPVariable = (WPVariable)editableInVarTableItemWrapper.getVariable();
        if (editableInVarTableItemWrapper.isCompositeKey()) {
            this.messageContainer.setCompositeKey(wPVariable.getMappedName(), null);
        } else {
            this.messageContainer.removeVariable(editableInVarTableItemWrapper.getVariable().getMappedName());
        }
        this.refreshTables();
        this.removeInVarButton.setEnabled(this.inVariablesTable.getSelectionIndex() != -1);
    }

    private WPVariable createVariable(SemanticElementFactory semanticElementFactory) {
        return (WPVariable)semanticElementFactory.createById("org.jbpm.gd.jpdl.variable");
    }

    private String getNextAvailableVariableName() {
        String string = "variable";
        int n = 1;
        while (this.hasTableVariableWithName(String.valueOf(string) + n)) {
            ++n;
        }
        return String.valueOf(string) + n;
    }

    private boolean hasTableVariableWithName(String string) {
        AbstractVariableTableItemWrapper abstractVariableTableItemWrapper;
        boolean bl = false;
        int n = this.outVariablesTable.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            abstractVariableTableItemWrapper = (AbstractVariableTableItemWrapper)this.outVariablesTable.getItem(n2).getData();
            if (string.equals(abstractVariableTableItemWrapper.getVariable().getMappedName())) {
                bl = true;
            }
            ++n2;
        }
        n = this.inVariablesTable.getItemCount();
        n2 = 0;
        while (n2 < n) {
            abstractVariableTableItemWrapper = (AbstractVariableTableItemWrapper)this.inVariablesTable.getItem(n2).getData();
            if (string.equals(abstractVariableTableItemWrapper.getVariable().getMappedName())) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }
}

