/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationManager;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionVariableConfiguration;
import com.tandbergtv.watchpoint.studio.ui.model.AbstractTaskNode;
import com.tandbergtv.watchpoint.studio.ui.properties.template.ArgumentTableItemWrapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNodeActionElementComposite
implements SelectionListener,
FocusListener {
    private AbstractTaskNode taskNode;
    private Composite parent;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Label classNameLabel;
    private Label argumentsLabel;
    private CCombo classNameCombo;
    private Table argumentsTable;
    private Button addButton;
    private Button removeButton;
    private Map<String, String> arguments;
    private static final String DEFAULT_CLASS_NAME = "";
    private static final String CLASS_NAME_LABEL = "Class Name: ";
    private static final String ARGUMENTS_LABEL = "Arguments: ";
    private static final String[] COLUMN_TITLES = new String[]{"Name", "Value"};

    public TaskNodeActionElementComposite(Composite composite, TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory) {
        this.parent = composite;
        this.widgetFactory = tabbedPropertySheetWidgetFactory;
        this.createControls();
    }

    private void createControls() {
        this.arguments = new LinkedHashMap<String, String>();
        this.create();
        this.initializeArgumentsTable();
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.classNameLabel = new Label(composite, 0);
        this.classNameLabel.setText(CLASS_NAME_LABEL);
        this.classNameLabel.setLayoutData((Object)this.createClassLabelLayoutData());
        this.classNameLabel.setBackground(ColorConstants.white);
        this.classNameLabel.pack();
        this.classNameCombo = this.widgetFactory.createCCombo(this.parent, 4);
        this.classNameCombo.setLayoutData((Object)this.createClassNameLayoutData(0, 85, 320));
        this.classNameCombo.setItems(this.getConfiguredClassNames());
        this.classNameCombo.add(DEFAULT_CLASS_NAME, 0);
        this.classNameCombo.setEditable(true);
        this.classNameCombo.addFocusListener((FocusListener)this);
        this.classNameCombo.pack();
        this.argumentsLabel = new Label(composite, 0);
        this.argumentsLabel.setText(ARGUMENTS_LABEL);
        this.argumentsLabel.setLayoutData((Object)this.createArgumentLabelLayoutData());
        this.argumentsLabel.setBackground(ColorConstants.white);
        this.argumentsLabel.pack();
        this.argumentsTable = this.widgetFactory.createTable(this.parent, 66304);
        this.argumentsTable.setLayoutData((Object)this.createArgumentsTableLayoutData());
        this.argumentsTable.addSelectionListener((SelectionListener)this);
        this.argumentsTable.pack();
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.removeButton.addSelectionListener((SelectionListener)this);
    }

    public void setTaskNode(AbstractTaskNode abstractTaskNode) {
        if (this.taskNode == abstractTaskNode) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.taskNode = abstractTaskNode;
        if (this.taskNode != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public AbstractTaskNode getTaskNode() {
        return this.taskNode;
    }

    private Action getAction() {
        return this.taskNode != null ? this.taskNode.getAction() : null;
    }

    private void hookListeners() {
        this.classNameCombo.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.argumentsTable.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.classNameCombo.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.argumentsTable.removeSelectionListener((SelectionListener)this);
    }

    private void updateControls() {
        Action action = this.taskNode.getAction();
        if (action != null) {
            Object object;
            if (action.getClassName() != null) {
                this.classNameCombo.setText(action.getClassName());
            }
            GenericElement[] genericElementArray = action.getGenericElements();
            this.arguments = new LinkedHashMap<String, String>();
            GenericElement[] genericElementArray2 = genericElementArray;
            int n = genericElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = genericElementArray2[n2];
                this.arguments.put(object.getName(), object.getValue());
                ++n2;
            }
            object = this.getArgumentNames(action.getClassName());
            if (object != null && object.size() > 0) {
                this.refreshTable(false);
                this.setAddButtonEnable(false);
                this.setRemoveButtonEnable(false);
            } else {
                this.refreshTable(true);
                this.setAddButtonEnable(true);
            }
        } else {
            action = this.createAction();
            this.taskNode.setAction(action);
        }
    }

    private void clearControls() {
        this.argumentsTable.removeAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void refreshTable(boolean bl) {
        this.argumentsTable.removeAll();
        this.removeAllGenericElements();
        Set<String> set = this.arguments.keySet();
        if (set != null) {
            for (String string : set) {
                GenericElement genericElement = this.createGenericElement();
                genericElement.setName(string);
                genericElement.setValue(this.arguments.get(string));
                new ArgumentTableItemWrapper(this, this.argumentsTable, genericElement, bl);
                this.addGenericElement(genericElement);
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.classNameCombo) {
            Action action = this.getAction();
            if (action != null) {
                if (this.isConfiguredClassName(action.getClassName())) {
                    this.handleClassNameComboSelected();
                } else {
                    this.setAddButtonEnable(true);
                }
            }
            this.updateClassNameText();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    private void updateClassNameText() {
        Action action = this.getAction();
        if (action != null) {
            action.setClassName(this.classNameCombo.getText());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.classNameCombo) {
            this.handleClassNameComboSelected();
        } else if (selectionEvent.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (selectionEvent.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        } else {
            Widget cfr_ignored_0 = selectionEvent.widget;
        }
    }

    public void setRemoveButtonEnable(boolean bl) {
        this.removeButton.setEnabled(bl);
    }

    public void setAddButtonEnable(boolean bl) {
        this.addButton.setEnabled(bl);
    }

    private void handleClassNameComboSelected() {
        String string = this.classNameCombo.getText();
        Action action = this.getAction();
        if (this.getAction() != null) {
            action.setClassName(string);
        } else {
            action = this.createAction();
            this.taskNode.setAction(action);
            this.getAction().setClassName(string);
        }
        this.arguments = new LinkedHashMap<String, String>();
        List<ActionVariableConfiguration> list = this.getArgumentNames(string);
        if (this.isConfiguredClassName(string)) {
            for (ActionVariableConfiguration actionVariableConfiguration : list) {
                this.arguments.put(actionVariableConfiguration.getName(), DEFAULT_CLASS_NAME);
            }
            this.refreshTable(false);
            this.setAddButtonEnable(false);
            this.setRemoveButtonEnable(false);
        } else {
            this.refreshTable(true);
            this.setAddButtonEnable(true);
        }
    }

    private void initializeTableColumns() {
        TableLayout tableLayout = (TableLayout)this.argumentsTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.argumentsTable, 16384);
        tableColumn.setText(COLUMN_TITLES[0]);
        tableColumn.pack();
        ColumnWeightData columnWeightData = new ColumnWeightData(5);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.argumentsTable, 16384);
        tableColumn2.setText(COLUMN_TITLES[1]);
        tableColumn2.setAlignment(0x1000000);
        tableColumn2.pack();
        ColumnWeightData columnWeightData2 = new ColumnWeightData(5);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
    }

    private void initializeArgumentsTable() {
        this.argumentsTable.setHeaderVisible(true);
        this.argumentsTable.setLinesVisible(true);
        this.argumentsTable.setLayout((Layout)new AutoResizeTableLayout(this.argumentsTable));
        this.initializeTableColumns();
        this.argumentsTable.pack();
    }

    private FormData createClassLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        return formData;
    }

    private FormData createArgumentLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.classNameLabel, 0);
        return formData;
    }

    private FormData createClassNameLayoutData(int n, int n2, int n3) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(n, n2);
        formData.top = new FormAttachment(0, 0);
        formData.width = n3;
        return formData;
    }

    private FormData createArgumentsTableLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.top = new FormAttachment((Control)this.classNameCombo, 2);
        formData.width = 400;
        formData.height = 100;
        return formData;
    }

    private FormData createAddButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.argumentsTable, 0);
        formData.top.alignment = 128;
        formData.left = new FormAttachment((Control)this.removeButton, 0);
        formData.left.alignment = 16384;
        formData.right = new FormAttachment(75, -5);
        return formData;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.addButton, 5);
        formData.left = new FormAttachment((Control)this.argumentsTable, 5);
        formData.right = new FormAttachment(75, -5);
        return formData;
    }

    private void handleAddButtonSelected() {
        int n = 1;
        String string = "Name" + n;
        while (this.arguments.containsKey(string)) {
            string = "Name" + ++n;
        }
        String string2 = "Value" + n;
        GenericElement genericElement = this.createGenericElement();
        genericElement.setName(string);
        genericElement.setValue(string2);
        this.arguments.put(string, string2);
        ArgumentTableItemWrapper argumentTableItemWrapper = new ArgumentTableItemWrapper(this, this.argumentsTable, genericElement, true);
        this.argumentsTable.setSelection(argumentTableItemWrapper.getTableItem());
        this.removeButton.setEnabled(this.argumentsTable.getSelectionIndex() != -1);
        this.addGenericElement(genericElement);
    }

    private void handleRemoveButtonSelected() {
        TableItem tableItem = this.argumentsTable.getItem(this.argumentsTable.getSelectionIndex());
        ArgumentTableItemWrapper argumentTableItemWrapper = (ArgumentTableItemWrapper)tableItem.getData();
        this.arguments.remove(argumentTableItemWrapper.getArgumentName());
        this.removeGenericElement(argumentTableItemWrapper.getArgumentName(), argumentTableItemWrapper.getArgumentValue());
        this.refreshTable(true);
        this.removeButton.setEnabled(this.argumentsTable.getSelectionIndex() != -1);
    }

    private String[] getConfiguredClassNames() {
        ActionConfigurationManager actionConfigurationManager = ActionConfigurationManager.getInstance();
        List<ActionClassConfiguration> list = actionConfigurationManager.getAllActionClasses();
        int n = list != null ? list.size() : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = list.get(n2).getClassName();
            ++n2;
        }
        return stringArray;
    }

    private boolean isConfiguredClassName(String string) {
        return ActionConfigurationManager.getInstance().getActionClass(string) != null;
    }

    private List<ActionVariableConfiguration> getArgumentNames(String string) {
        ActionConfigurationManager actionConfigurationManager = ActionConfigurationManager.getInstance();
        ActionClassConfiguration actionClassConfiguration = actionConfigurationManager.getActionClass(string);
        if (actionClassConfiguration != null) {
            return actionClassConfiguration.getVariables();
        }
        return null;
    }

    private void addGenericElement(GenericElement genericElement) {
        Action action = this.getAction();
        if (action != null) {
            action.addGenericElement(genericElement);
        }
    }

    private void removeGenericElement(String string, String string2) {
        Action action = this.getAction();
        if (action != null) {
            GenericElement[] genericElementArray;
            GenericElement[] genericElementArray2 = genericElementArray = action.getGenericElements();
            int n = genericElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement genericElement = genericElementArray2[n2];
                if (string != null && string.equals(genericElement.getName())) {
                    action.removeGenericElement(genericElement);
                }
                ++n2;
            }
        }
    }

    private void removeAllGenericElements() {
        Action action = this.getAction();
        if (action != null) {
            GenericElement[] genericElementArray;
            GenericElement[] genericElementArray2 = genericElementArray = action.getGenericElements();
            int n = genericElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement genericElement = genericElementArray2[n2];
                action.removeGenericElement(genericElement);
                ++n2;
            }
        }
    }

    private GenericElement createGenericElement() {
        return (GenericElement)this.taskNode.getFactory().createById("org.jbpm.gd.jpdl.genericElement");
    }

    private Action createAction() {
        return (Action)this.taskNode.getFactory().createById("org.jbpm.gd.jpdl.action");
    }
}

