/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class WPConditionSection
extends AbstractPropertySection
implements FocusListener,
KeyListener,
IContentProposalListener {
    private static final Logger logger = Logger.getLogger(WPConditionSection.class);
    private Label label;
    private Text expressionText;
    private Transition transition;
    private ContentProposalAdapter adapter;
    private String keyPressedValue = "";

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
        Composite composite2 = this.getWidgetFactory().createFlatFormComposite(composite);
        this.label = this.getWidgetFactory().createLabel(composite2, "Condition");
        this.expressionText = this.getWidgetFactory().createText(composite2, "");
        this.label.setLayoutData((Object)this.createLabelLayoutData());
        this.expressionText.setLayoutData((Object)this.createExpressionTextLayoutData());
        this.adapter = this.createAdapter(this.expressionText, this.getTextProposals(), true);
        this.hookListeners();
        this.refresh();
    }

    private void hookListeners() {
        this.expressionText.addFocusListener((FocusListener)this);
        this.expressionText.addKeyListener((KeyListener)this);
        this.adapter.addContentProposalListener((IContentProposalListener)this);
    }

    private FormData createLabelLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(10, 0);
        formData.left = new FormAttachment(0, 0);
        return formData;
    }

    private FormData createExpressionTextLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(10, 0);
        formData.left = new FormAttachment((Control)this.label, 0);
        formData.right = new FormAttachment(100, 0);
        return formData;
    }

    public void setInput(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        super.setInput(iWorkbenchPart, iSelection);
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement abstractNotationElement = ((NotationElementGraphicalEditPart)object).getNotationElement();
            object = abstractNotationElement.getSemanticElement();
        } else if (object instanceof OutlineEditPart) {
            object = ((OutlineEditPart)object).getModel();
        }
        if (object instanceof Transition) {
            this.transition = (Transition)object;
            this.refresh();
        }
    }

    public void refresh() {
        Condition condition = this.transition.getCondition();
        if (condition != null && condition.getExpression() != null) {
            this.expressionText.setText(condition.getExpression());
        } else {
            this.expressionText.setText("");
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.adapter.setEnabled(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.expressionText) {
            this.handleExpressionTextChanged();
        }
        if (Utility.getNodeElementContainer(this.getPart()) != null) {
            this.validate();
        }
    }

    private void handleExpressionTextChanged() {
        if (this.expressionText.getText().trim().length() == 0) {
            this.transition.setCondition(null);
        } else {
            if (this.transition.getCondition() == null) {
                Condition condition = (Condition)this.transition.getFactory().createById("org.jbpm.gd.jpdl.condition");
                this.transition.setCondition(condition);
            }
            this.transition.getCondition().setExpression(this.expressionText.getText());
        }
    }

    private void validate() {
        ValidationServiceFactory validationServiceFactory = ValidationServiceFactory.createFactory();
        IValidationService iValidationService = validationServiceFactory.createValidationService();
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(this.getPart());
        List<ValidationMessage> list = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            list = iValidationService.validateCondition(this.transition.getSource(), this.transition, (WorkflowTemplate)nodeElementContainer);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            list = iValidationService.validateCondition(this.transition.getSource(), this.transition, (NodeDefinition)nodeElementContainer);
        }
        if (list != null && list.size() > 0) {
            try {
                String string = ValidationMessages.getInstance().getMessage(list.get(0));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error in Condition Expression", (String)string);
            }
            catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)invalidPropertiesFormatException);
                throw new UIException("Error occured while opening the Message Dialog");
            }
            catch (IOException iOException) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)iOException);
                throw new UIException("Error occured while opening the Message Dialog");
            }
        }
    }

    private ContentProposalAdapter createAdapter(Text text, String[] stringArray, boolean bl) {
        char[] cArray = new char[]{};
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException parseException) {
            logger.error((Object)"Error occured while Creating instance of KeyStroke", (Throwable)parseException);
            throw new UIException("Error occured while Creating instance of KeyStroke");
        }
        SimpleContentProposalProvider simpleContentProposalProvider = new SimpleContentProposalProvider(stringArray);
        ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)simpleContentProposalProvider, keyStroke, cArray);
        contentProposalAdapter.setProposalAcceptanceStyle(1);
        contentProposalAdapter.setFilterStyle(3);
        contentProposalAdapter.setPropagateKeys(bl);
        contentProposalAdapter.setEnabled(false);
        return contentProposalAdapter;
    }

    private String[] getTextProposals() {
        List<WPVariable> list = Utility.getVariables(Utility.getNodeElementContainer(this.getPart()));
        HashSet<String> hashSet = new HashSet<String>();
        for (WPVariable stringArray2 : list) {
            hashSet.add(stringArray2.getName());
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        return stringArray;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u0000') {
            this.keyPressedValue = this.getFilter();
        } else if (keyEvent.character == '\b' && this.keyPressedValue.length() > 0) {
            this.keyPressedValue = this.keyPressedValue.substring(0, this.keyPressedValue.length() - 1);
        } else if (Character.isLetterOrDigit(keyEvent.character)) {
            this.keyPressedValue = String.valueOf(this.keyPressedValue) + keyEvent.character;
        }
        SimpleContentProposalProvider simpleContentProposalProvider = new SimpleContentProposalProvider(this.filterProposals(this.keyPressedValue));
        this.adapter.setContentProposalProvider((IContentProposalProvider)simpleContentProposalProvider);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void proposalAccepted(IContentProposal iContentProposal) {
        String string = this.expressionText.getText();
        String string2 = String.valueOf(this.keyPressedValue) + iContentProposal.getContent();
        int n = string.lastIndexOf(string2);
        int n2 = this.expressionText.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer();
        if (n != -1) {
            stringBuffer.append(string.substring(0, n2 - string2.length()));
            stringBuffer.append(iContentProposal.getContent());
            stringBuffer.append(string.substring(n2));
        } else {
            stringBuffer.append(string);
            stringBuffer.append(iContentProposal.getContent());
        }
        this.expressionText.setText(stringBuffer.toString());
        this.expressionText.setSelection(n2);
        this.keyPressedValue = "";
    }

    private String[] filterProposals(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getTextProposals();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string2.startsWith(string)) {
                arrayList.add(string2);
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getFilter() {
        String string = this.expressionText.getText();
        int n = this.expressionText.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 > 0) {
            char c = string.charAt(n2 - 1);
            if (c == ' ' || c == '|' || c == '&' || c == '=' || c == '(') break;
            stringBuffer.insert(0, c);
            --n2;
        }
        return stringBuffer.toString();
    }
}

