/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.NodeElement;

public class WPNamedElementComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite wrappedComposite;
    private Label nameLabel;
    private Text nameText;
    private NamedElement namedElement;
    private AbstractPropertySection parentPropertySection;

    public WPNamedElementComposite(AbstractPropertySection abstractPropertySection, Composite composite, TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory) {
        this.parentPropertySection = abstractPropertySection;
        this.wrappedComposite = composite;
        this.widgetFactory = tabbedPropertySheetWidgetFactory;
        this.initialize();
    }

    private void initialize() {
        this.nameLabel = this.widgetFactory.createLabel(this.wrappedComposite, "Name");
        this.nameText = this.widgetFactory.createText(this.wrappedComposite, "");
        FormData formData = null;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 2);
        this.nameLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.top = new FormAttachment(0, 0);
        formData.width = 300;
        this.nameText.setLayoutData((Object)formData);
    }

    public void setNamedElement(NamedElement namedElement) {
        this.unhookListeners();
        this.clearControls();
        this.namedElement = namedElement;
        if (namedElement != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.nameText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.nameText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.nameText.setText("");
        this.nameText.setEnabled(true);
        this.nameText.setTextLimit(Text.LIMIT);
    }

    private void updateControls() {
        String string = this.namedElement.getName();
        this.nameText.setText(string == null ? "" : string);
        boolean bl = true;
        int n = Text.LIMIT;
        IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
        if (this.namedElement instanceof WorkflowTemplate) {
            bl = false;
            n = 50;
        } else if (iWorkbenchPart instanceof NodeDefinitionEditor && this.isReadOnlyNamedElement((NodeDefinitionEditor)iWorkbenchPart)) {
            bl = false;
            n = 50;
        }
        this.nameText.setEnabled(bl);
        this.nameText.setTextLimit(n);
    }

    private String getNameText() {
        String string = this.nameText.getText();
        if ("".equals(string) && !this.namedElement.isNameMandatory()) {
            string = null;
        }
        return string;
    }

    private boolean isReadOnlyNamedElement(NodeDefinitionEditor nodeDefinitionEditor) {
        boolean bl;
        NodeDefinition nodeDefinition = nodeDefinitionEditor.getNodeDefinition();
        if (nodeDefinition == null) {
            return false;
        }
        NodeDefinitionType nodeDefinitionType = nodeDefinition.getNodeType();
        boolean bl2 = nodeDefinition == this.namedElement;
        boolean bl3 = bl = nodeDefinitionType == NodeDefinitionType.SingleNode && nodeDefinition.getNode() == this.namedElement;
        return bl2 || bl;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.nameText) {
            if (this.namedElement == null) {
                return;
            }
            String string = this.nameText.getText().trim();
            if (this.namedElement.isNameMandatory() && "".equals(string)) {
                Shell shell = Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"The name cannot be blank.");
                this.nameText.setText(this.namedElement.getName());
                return;
            }
            if (this.namedElement instanceof NodeElement) {
                IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
                SemanticElement semanticElement = null;
                if (iWorkbenchPart instanceof WatchPointTemplateEditor) {
                    semanticElement = ((WatchPointTemplateEditor)iWorkbenchPart).getProcessDefinition();
                } else if (iWorkbenchPart instanceof NodeDefinitionEditor) {
                    semanticElement = ((NodeDefinitionEditor)iWorkbenchPart).getNodeDefinition();
                }
                if (semanticElement.getNodeElementByName(string) != null && semanticElement.getNodeElementByName(string) != this.namedElement) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("There is already a node named " + string + "."));
                    this.nameText.setText(this.namedElement.getName());
                    return;
                }
            }
            if (!string.equals(this.nameText.getText())) {
                this.nameText.setText(string);
            }
            this.namedElement.setName(this.getNameText());
        }
    }
}

