/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.util;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;

public class ValidationMessages
extends Properties {
    private static final String PARAM_START = "<![";
    private static final String PARAM_END = "]>";
    private static final long serialVersionUID = -9033237554511674020L;
    private static final String RESOURCE_PATH = "/ValidationMessages.properties";
    private static ValidationMessages instance;

    private ValidationMessages() throws InvalidPropertiesFormatException, IOException {
        this.loadProperties();
    }

    public static synchronized ValidationMessages getInstance() throws InvalidPropertiesFormatException, IOException {
        if (instance == null) {
            instance = new ValidationMessages();
        }
        return instance;
    }

    public String getMessage(ValidationMessage validationMessage) {
        String string = validationMessage.getCode();
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return "";
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n < string2.length()) {
            int n2;
            int n3 = string2.indexOf(PARAM_START, n);
            int n4 = n2 = n3 != -1 ? string2.indexOf(PARAM_END, n3) : -1;
            if (n3 != -1) {
                stringBuilder.append(string2.substring(n, n3));
                if (n2 != -1) {
                    String string3 = string2.substring(n3 + PARAM_START.length(), n2);
                    String string4 = this.getReplacementParameterValue(string3, validationMessage);
                    stringBuilder.append(string4);
                    n = n2 + PARAM_END.length();
                    continue;
                }
                n = n3 + PARAM_START.length();
                continue;
            }
            stringBuilder.append(string2.substring(n, string2.length()));
            n = string2.length();
        }
        return stringBuilder.toString();
    }

    private String getReplacementParameterValue(String string, ValidationMessage validationMessage) {
        List<String> list = validationMessage.getParameterValues();
        if (list == null || string == null) {
            return "";
        }
        String string2 = string;
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string2;
        }
        if (n >= 0 && n < list.size()) {
            string2 = list.get(n);
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    private void loadProperties() throws InvalidPropertiesFormatException, IOException {
        this.load(ValidationMessages.class.getResourceAsStream(RESOURCE_PATH));
    }
}

