/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeViewExplorer
extends ViewPart
implements IDoubleClickListener,
ISelectionChangedListener {
    private TreeViewer treeViewer;
    protected Action createAction;
    protected Action viewAction;
    protected Action editAction;
    protected Action deleteAction;
    protected Action refreshAction;

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getLayoutData());
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)this.getTreePanelData());
        composite2.pack();
        this.treeViewer = this.createTreeViewer(composite2);
        composite.pack();
        this.createActions();
        this.createContextMenu();
        this.createToolbar();
        this.hookGlobalActions();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        this.edit();
    }

    public void refresh() {
        this.treeViewer.getTree().setRedraw(false);
        try {
            Object[] objectArray = this.getTreeViewer().getExpandedElements();
            this.treeViewer.setInput(this.getInput());
            this.getTreeViewer().setExpandedElements(objectArray);
        }
        finally {
            this.treeViewer.getTree().setRedraw(true);
        }
    }

    protected void createToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.createAction);
        iToolBarManager.add((IAction)this.viewAction);
        iToolBarManager.add((IAction)this.editAction);
        iToolBarManager.add((IAction)this.deleteAction);
        iToolBarManager.add((IAction)this.refreshAction);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.viewAction);
        iMenuManager.add((IAction)this.editAction);
        iMenuManager.add((IAction)this.deleteAction);
    }

    protected void createActions() {
        this.createAction = new ViewAction(this, "Create"){

            public void performAction() {
                AbstractTreeViewExplorer.this.create();
            }
        };
        this.createAction.setImageDescriptor(Utility.getImageDescriptor("create.png"));
        this.viewAction = new ViewAction(this, "View"){

            public void performAction() {
                AbstractTreeViewExplorer.this.view();
            }
        };
        this.viewAction.setImageDescriptor(Utility.getImageDescriptor("view.png"));
        this.editAction = new ViewAction(this, "Edit"){

            public void performAction() {
                AbstractTreeViewExplorer.this.edit();
            }
        };
        this.editAction.setImageDescriptor(Utility.getImageDescriptor("edit.png"));
        this.deleteAction = new ViewAction(this, "Delete"){

            public void performAction() {
                AbstractTreeViewExplorer.this.delete();
            }
        };
        this.deleteAction.setImageDescriptor(Utility.getImageDescriptor("delete.png"));
        this.refreshAction = new ViewAction(this, "Refresh"){

            public void performAction() {
                AbstractTreeViewExplorer.this.refresh();
            }
        };
        this.refreshAction.setImageDescriptor(Utility.getImageDescriptor("refresh.png"));
    }

    protected ITreeSelection getSelection() {
        return (ITreeSelection)this.treeViewer.getSelection();
    }

    protected abstract List<? extends IWatchPointDTO> getInput();

    protected abstract void create();

    protected abstract void view();

    protected abstract void edit();

    protected abstract void delete();

    protected abstract IContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();

    private GridData getLayoutData() {
        GridData gridData = new GridData(4, 4, true, true, 5, 5);
        gridData.minimumHeight = 300;
        return gridData;
    }

    private GridData getTreePanelData() {
        GridData gridData = new GridData(4, 4, true, true);
        return gridData;
    }

    protected void hookGlobalActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite, 4);
        treeViewer.setContentProvider(this.getContentProvider());
        treeViewer.setLabelProvider(this.getLabelProvider());
        treeViewer.setInput(this.getInput());
        treeViewer.getTree().setLayout((Layout)new GridLayout());
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        treeViewer.setComparator(new ViewerComparator());
        return treeViewer;
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                AbstractTreeViewExplorer.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
    }
}

