/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractValidationProvider {
    protected List<ValidationMessage> validationErrors = new ArrayList<ValidationMessage>();
    protected List<ValidationMessage> validationWarnings = new ArrayList<ValidationMessage>();
    protected List<ValidationMessage> validationNotifications = new ArrayList<ValidationMessage>();
    protected String errorString;
    protected String warningString;
    protected String notificationString;

    public AbstractValidationProvider(List<ValidationMessage> list, String string, String string2, String string3) {
        this.errorString = string;
        this.warningString = string2;
        this.notificationString = string3;
        this.setInput(list);
    }

    protected void setInput(List<ValidationMessage> list) {
        this.validationErrors.clear();
        this.validationWarnings.clear();
        this.validationNotifications.clear();
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.getType() == ValidationMessageType.Error) {
                this.validationErrors.add(validationMessage);
                continue;
            }
            if (validationMessage.getType() == ValidationMessageType.Warning) {
                this.validationWarnings.add(validationMessage);
                continue;
            }
            if (validationMessage.getType() != ValidationMessageType.Notification) continue;
            this.validationNotifications.add(validationMessage);
        }
    }

    protected int getListCount(String string) {
        if (string.equals(this.errorString)) {
            return this.validationErrors.size();
        }
        if (string.equals(this.warningString)) {
            return this.validationWarnings.size();
        }
        if (string.equals(this.notificationString)) {
            return this.validationNotifications.size();
        }
        return 0;
    }
}

