/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrorsView
extends ViewPart
implements IPartListener2 {
    private static final String ELEMENT_TYPE_COLUMN = "Element Type";
    private static final String ELEMENT_NAME_COLUMN = "Element Name";
    private static final String DESCRIPTION_COLUMN = "Description";
    private TreeViewer treeViewer;
    private Action validateAction;
    private IValidationService validationService = ValidationServiceFactory.createFactory().createValidationService();
    private ValidationContentProvider contentProvider;

    public void createPartControl(Composite composite) {
        this.setPartName("Validation Errors");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getLayoutData());
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)this.getTreePanelData());
        composite2.pack();
        this.createTreeViewer(composite2);
        composite.pack();
        this.createActions();
        this.createToolbar();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void updateValidationMessages(List<ValidationMessage> list) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        if (list != null) {
            arrayList.addAll(list);
        }
        this.treeViewer.getTree().setRedraw(false);
        try {
            this.treeViewer.setInput(arrayList);
            this.treeViewer.expandToLevel(2);
        }
        finally {
            this.treeViewer.getTree().setRedraw(true);
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
    }

    private GridData getTreePanelData() {
        GridData gridData = new GridData(4, 4, true, true);
        return gridData;
    }

    private GridData getLayoutData() {
        GridData gridData = new GridData(4, 4, true, true, 5, 5);
        gridData.minimumHeight = 300;
        return gridData;
    }

    private void createTreeViewer(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 4);
        this.treeViewer.getTree().setHeaderVisible(true);
        Tree tree = this.treeViewer.getTree();
        TreeColumn treeColumn = new TreeColumn(tree, 16384);
        treeColumn.setText(DESCRIPTION_COLUMN);
        treeColumn.setWidth(400);
        treeColumn = new TreeColumn(tree, 16384);
        treeColumn.setText(ELEMENT_NAME_COLUMN);
        treeColumn.setWidth(200);
        treeColumn = new TreeColumn(tree, 16384);
        treeColumn.setText(ELEMENT_TYPE_COLUMN);
        treeColumn.setWidth(200);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setLayout((Layout)new GridLayout());
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new ValidationContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
        this.treeViewer.setInput(new ArrayList());
        this.treeViewer.expandAll();
    }

    private void validate() {
        this.updateValidationMessages(null);
        IEditorPart iEditorPart = Utility.getActiveEditor();
        if (iEditorPart == null) {
            return;
        }
        List<ValidationMessage> list = null;
        if (iEditorPart instanceof WatchPointTemplateEditor) {
            WorkflowTemplate workflowTemplate = ((WatchPointTemplateEditor)iEditorPart).getProcessDefinition();
            if (workflowTemplate == null) {
                return;
            }
            list = this.validationService.validateTemplate(workflowTemplate);
        } else if (iEditorPart instanceof NodeDefinitionEditor) {
            NodeDefinition nodeDefinition = ((NodeDefinitionEditor)iEditorPart).getNodeDefinition();
            if (nodeDefinition == null) {
                return;
            }
            list = this.validationService.validateNodeDefinition(nodeDefinition);
        } else if (iEditorPart instanceof ResourceTypeEditor) {
            ResourceType resourceType = ((ResourceTypeEditor)iEditorPart).getResourceType();
            if (resourceType == null) {
                return;
            }
            list = this.validationService.validateResourceType(resourceType);
        }
        this.updateValidationMessages(list);
    }

    private void createActions() {
        this.validateAction = new ViewAction(this, "Validate"){

            public void performAction() {
                ValidationErrorsView.this.validate();
            }
        };
        this.validateAction.setImageDescriptor(Utility.getImageDescriptor("validate.png"));
        this.validateAction.setToolTipText("Validate");
    }

    private void createToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.validateAction);
    }

    public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
    }
}

