/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.resourcegroup;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.ui.view.resourcegroup.ResourceGroupLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupExportWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupExplorer
extends AbstractTreeViewExplorer {
    private IResourceGroupService rgService;
    private Action exportAction;
    private IResourceTypeService rtService;
    private ResourceGroupContentProvider contentProvider = new ResourceGroupContentProvider();
    private Map<ResourceType, List<ResourceGroup>> resourceTypeGroups = new HashMap<ResourceType, List<ResourceGroup>>();

    public ResourceGroupExplorer() {
        ServiceFactory serviceFactory = ServiceFactory.createFactory();
        this.rgService = serviceFactory.createResourceGroupService();
        this.rtService = serviceFactory.createResourceTypeService();
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        this.resourceTypeGroups = this.getResourceGroupsByResourceType();
        List<ResourceType> list = this.rtService.getViewableResourceTypeList();
        return list;
    }

    @Override
    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new ResourceGroupLabelProvider();
    }

    @Override
    protected void create() {
        if (this.openWizard((IWizard)new ResourceGroupWizard(ResourceGroupWizardPage.Mode.CREATE, null))) {
            this.refresh();
        }
    }

    @Override
    protected void view() {
        ResourceGroup resourceGroup = (ResourceGroup)((TreeSelection)this.getSelection()).getFirstElement();
        if (resourceGroup == null) {
            MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to view.");
            return;
        }
        this.openWizard((IWizard)new ResourceGroupWizard(ResourceGroupWizardPage.Mode.VIEW, resourceGroup));
    }

    @Override
    protected void edit() {
        Object object = ((TreeSelection)this.getSelection()).getFirstElement();
        if (object instanceof ResourceGroup) {
            ResourceGroup resourceGroup = (ResourceGroup)object;
            if (resourceGroup == null) {
                MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to edit.");
                return;
            }
            if (this.openWizard((IWizard)new ResourceGroupWizard(ResourceGroupWizardPage.Mode.EDIT, resourceGroup))) {
                this.refresh();
            }
        }
    }

    @Override
    protected void delete() {
        ResourceGroup resourceGroup = (ResourceGroup)((TreeSelection)this.getSelection()).getFirstElement();
        if (resourceGroup == null) {
            MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to delete.");
            return;
        }
        String string = "Are you sure you want to delete the resource group '" + resourceGroup.getName() + "'?";
        boolean bl = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Confirm Delete", (String)string);
        if (!bl) {
            return;
        }
        try {
            this.rgService.deleteResourceGroup(resourceGroup);
        }
        catch (Exception exception) {
            Utility.reportError("Resource Group Deletion Failed", exception);
        }
        this.refresh();
    }

    @Override
    protected void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        iMenuManager.add((IAction)this.exportAction);
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.exportAction);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.exportAction = new ViewAction(this, "Export"){

            public void performAction() {
                ResourceGroup resourceGroup = (ResourceGroup)((TreeSelection)ResourceGroupExplorer.this.getSelection()).getFirstElement();
                if (resourceGroup == null) {
                    MessageDialog.openInformation((Shell)ResourceGroupExplorer.this.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to export.");
                    return;
                }
                ResourceGroupExplorer.this.openWizard((IWizard)new ResourceGroupExportWizard(resourceGroup));
            }
        };
        this.exportAction.setImageDescriptor(Utility.getImageDescriptor("export.png"));
    }

    @Override
    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        Object object = ((TreeSelection)iSelection).getFirstElement();
        if (object instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)object;
            if (resourceType != null) {
                this.deleteAction.setEnabled(false);
                this.createAction.setEnabled(true);
                this.editAction.setEnabled(false);
                this.viewAction.setEnabled(false);
                this.exportAction.setEnabled(false);
            }
        } else {
            ResourceGroup resourceGroup = (ResourceGroup)object;
            if (resourceGroup != null) {
                this.createAction.setEnabled(true);
                this.editAction.setEnabled(true);
                this.viewAction.setEnabled(true);
                this.exportAction.setEnabled(true);
                this.deleteAction.setEnabled(resourceGroup.getVersion() == 1 && resourceGroup.isDirty());
            }
        }
    }

    private boolean openWizard(IWizard iWizard) {
        WizardDialog wizardDialog;
        IWorkbench iWorkbench = super.getSite().getWorkbenchWindow().getWorkbench();
        if (iWizard instanceof INewWizard) {
            ((INewWizard)iWizard).init(iWorkbench, (IStructuredSelection)new StructuredSelection());
        }
        return (wizardDialog = new WizardDialog(iWorkbench.getActiveWorkbenchWindow().getShell(), iWizard)).open() == 0;
    }

    private Map<ResourceType, List<ResourceGroup>> getResourceGroupsByResourceType() {
        List<ResourceGroup> list = this.rgService.getAllResourceGroups();
        HashMap<ResourceType, List<ResourceGroup>> hashMap = new HashMap<ResourceType, List<ResourceGroup>>();
        for (ResourceGroup resourceGroup : list) {
            if (resourceGroup.getResourceType() == null) continue;
            ResourceType resourceType = resourceGroup.getResourceType();
            ArrayList<ResourceGroup> arrayList = (ArrayList<ResourceGroup>)hashMap.get(resourceType);
            if (arrayList == null) {
                arrayList = new ArrayList<ResourceGroup>();
                arrayList.add(resourceGroup);
                hashMap.put(resourceType, arrayList);
                continue;
            }
            arrayList.add(resourceGroup);
            hashMap.put(resourceType, arrayList);
        }
        return hashMap;
    }

    private class ResourceGroupContentProvider
    extends DefaultContentProvider {
        private ResourceGroupContentProvider() {
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = null;
            if (object instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)object;
                List list = (List)ResourceGroupExplorer.this.resourceTypeGroups.get(resourceType);
                if (list != null) {
                    objectArray = list.toArray();
                }
            } else {
                objectArray = super.getChildren(object);
            }
            return objectArray;
        }

        public Object getParent(Object object) {
            Object object2 = null;
            if (object instanceof ResourceGroup) {
                ResourceGroup resourceGroup = (ResourceGroup)object;
                object2 = resourceGroup.getResourceType();
            } else {
                object2 = super.getParent(object);
            }
            return object2;
        }

        public boolean hasChildren(Object object) {
            boolean bl = false;
            if (object instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)object;
                List list = (List)ResourceGroupExplorer.this.resourceTypeGroups.get(resourceType);
                bl = list != null && list.size() > 0;
            } else {
                bl = super.hasChildren(object);
            }
            return bl;
        }
    }
}

